/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.date;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.date.DateOperator;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;

public class MillisDateOperator
extends DateOperator {
    private Date theDate;

    public MillisDateOperator(String longValue) {
        try {
            this.theDate = new Date(Long.parseLong(longValue));
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot parse long value");
        }
    }

    public MillisDateOperator(Date value) {
        this.theDate = value;
    }

    @Override
    public String getLabel() {
        return this.theDate.getTime() + "l";
    }

    @Override
    public int getMaxOperands() {
        return 0;
    }

    @Override
    public int getMinOperands() {
        return 0;
    }

    @Override
    protected Date performOperation(List<Operator<?>> operands) {
        return this.theDate;
    }
}

