/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.date;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.date.DateOperator;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class RelativeDateOperator
extends DateOperator {
    private String label;
    private int years = 0;
    private int months = 0;
    private int weeks = 0;
    private int days = 0;
    private int hours = 0;

    public RelativeDateOperator(String toWrangle) {
        this.wrangle(toWrangle);
    }

    private void wrangle(String toWrangle) {
        if (toWrangle.equalsIgnoreCase("now")) {
            this.label = "now";
            return;
        }
        String[] splits = toWrangle.split(" ");
        if (splits != null && splits.length > 0) {
            for (String nextSplit : splits) {
                this.parseSplits(nextSplit.trim());
            }
        }
        StringBuilder SB = new StringBuilder();
        if (this.years != 0) {
            SB.append(this.years).append("y ");
        }
        if (this.months != 0) {
            SB.append(this.months).append("m ");
        }
        if (this.weeks != 0) {
            SB.append(this.weeks).append("w ");
        }
        if (this.days != 0) {
            SB.append(this.days).append("d ");
        }
        if (this.hours != 0) {
            SB.append(this.hours).append("h ");
        }
        this.label = SB.toString().trim();
    }

    private void parseSplits(String split) {
        if (split.isEmpty()) {
            return;
        }
        int index = 0;
        for (int i = 0; i < split.length(); ++i) {
            char valChar = split.charAt(i);
            if (Character.isDigit(valChar) || '-' == valChar) continue;
            index = i;
            break;
        }
        int value = 1;
        if (index > 0) {
            try {
                value = Integer.parseInt(split.substring(0, index));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        char designator = split.charAt(index);
        switch (designator) {
            case 'd': {
                this.days = value;
                break;
            }
            case 'w': {
                this.weeks = value;
                break;
            }
            case 'm': {
                this.months = value;
                break;
            }
            case 'y': {
                this.years = value;
                break;
            }
            case 'h': {
                this.hours = value;
                break;
            }
        }
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getMaxOperands() {
        return 1;
    }

    @Override
    public int getMinOperands() {
        return 0;
    }

    @Override
    protected Date performOperation(List<Operator<?>> operands) {
        Calendar cal = Calendar.getInstance();
        if (operands.size() > 0) {
            cal.setTime((Date)operands.get(0).getValue());
        }
        if (this.years != 0) {
            cal.add(1, this.years);
        }
        if (this.months != 0) {
            cal.add(2, this.months);
        }
        if (this.weeks != 0) {
            cal.add(3, this.weeks);
        }
        if (this.days != 0) {
            cal.add(5, this.days);
        }
        if (this.hours != 0) {
            cal.add(10, this.hours);
        }
        return cal.getTime();
    }
}

