/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.numeric;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.numeric.NumericOperator;
import au.com.ordermate.operator.numeric.NumericOperatorType;
import java.util.List;

public class DivisionOperator
extends NumericOperator {
    @Override
    public String getLabel() {
        return NumericOperatorType.Div.name();
    }

    @Override
    public int getMaxOperands() {
        return 2;
    }

    @Override
    public int getMinOperands() {
        return 2;
    }

    @Override
    protected Number performOperation(List<Operator<?>> operands) {
        Number denominator = (Number)operands.get(1).getValue();
        if (denominator == null || Double.isNaN(denominator.doubleValue()) || denominator.doubleValue() == 0.0) {
            return Double.NaN;
        }
        Number numerator = (Number)operands.get(0).getValue();
        if (numerator != null && !Double.isNaN(numerator.doubleValue())) {
            return numerator.doubleValue() / denominator.doubleValue();
        }
        return Double.NaN;
    }
}

