/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.numeric;

import au.com.ordermate.operator.AbstractOperatorFactory;
import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.numeric.AbsoluteOperator;
import au.com.ordermate.operator.numeric.DivisionOperator;
import au.com.ordermate.operator.numeric.MultiplicationOperator;
import au.com.ordermate.operator.numeric.NumberOperator;
import au.com.ordermate.operator.numeric.NumericOperatorType;
import au.com.ordermate.operator.numeric.RoundOperator;
import au.com.ordermate.operator.numeric.SubtractOperator;
import au.com.ordermate.operator.numeric.SumOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;

public class NumericOperatorFactory
extends AbstractOperatorFactory {
    private List<String> ops;
    private Map<String, Class> typeMap = new HashMap<String, Class>();

    public NumericOperatorFactory() {
        this.typeMap.put(NumericOperatorType.Abs.name().toLowerCase(), AbsoluteOperator.class);
        this.typeMap.put(NumericOperatorType.Div.name().toLowerCase(), DivisionOperator.class);
        this.typeMap.put(NumericOperatorType.Mult.name().toLowerCase(), MultiplicationOperator.class);
        this.typeMap.put(NumericOperatorType.Sum.name().toLowerCase(), SumOperator.class);
        this.typeMap.put(NumericOperatorType.Sub.name().toLowerCase(), SubtractOperator.class);
        this.typeMap.put(NumericOperatorType.Round.name().toLowerCase(), RoundOperator.class);
    }

    @Override
    protected Operator makeOperatorFor(String label) {
        String lowerLabel = label.toLowerCase();
        if (this.typeMap.containsKey(lowerLabel)) {
            try {
                Operator op = (Operator)this.typeMap.get(lowerLabel).getConstructor(new Class[0]).newInstance(new Object[0]);
                return op;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot instantiate class of " + this.typeMap.get(label), (Throwable)ex);
                return null;
            }
        }
        try {
            double value = Double.parseDouble(label);
            NumberOperator constOp = new NumberOperator(value);
            return constOp;
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot Parse number for a constant Op", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<String> getOperators() {
        if (this.ops == null) {
            this.ops = new ArrayList<String>();
            for (NumericOperatorType type : NumericOperatorType.values()) {
                this.ops.add(type.name());
            }
        }
        return this.ops;
    }
}

