/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.numeric;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.numeric.NumericOperator;
import au.com.ordermate.operator.numeric.NumericOperatorType;
import au.com.ordermate.util.MathsUtils;
import java.util.List;

public class RoundOperator
extends NumericOperator {
    @Override
    public String getLabel() {
        return NumericOperatorType.Round.name();
    }

    @Override
    public int getMaxOperands() {
        return 2;
    }

    @Override
    public int getMinOperands() {
        return 2;
    }

    @Override
    protected Number performOperation(List<Operator<?>> operands) {
        Object value = operands.get(0).getValue();
        if (value == null) {
            return null;
        }
        return MathsUtils.roundDoubleToDecPlaces(((Number)value).doubleValue(), ((Number)operands.get(1).getValue()).intValue());
    }
}

