/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.numeric;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.numeric.NumericOperator;
import au.com.ordermate.operator.numeric.NumericOperatorType;
import java.util.List;

public class SumOperator
extends NumericOperator {
    @Override
    public String getLabel() {
        return NumericOperatorType.Sum.name();
    }

    @Override
    public int getMaxOperands() {
        return -1;
    }

    @Override
    public int getMinOperands() {
        return 1;
    }

    @Override
    protected Number performOperation(List<Operator<?>> operands) {
        double tally = 0.0;
        for (Operator<?> nextOp : operands) {
            Number next = (Number)nextOp.getValue();
            if (next == null || Double.isNaN(next.doubleValue())) continue;
            tally += next.doubleValue();
        }
        return tally;
    }
}

