/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Set;

public abstract class AbstractPropertyQueryComponent
implements QueryComponent {
    private PropertiedObject.Property property;
    private String table;
    private String column;
    private String className;

    protected AbstractPropertyQueryComponent() {
    }

    public AbstractPropertyQueryComponent(PropertiedObject.Property newProperty) {
        this.property = newProperty;
    }

    @Override
    public void resolve(PersistenceMetaData persistence) {
        if (this.property == null) {
            throw new NullPointerException();
        }
        if (!PersistenceManager.getInstance().classSupportsQueries(this.property.getOwner())) {
            throw new QueryException("Problem with query component (Property: " + this.property.getLabel() + ").  Class " + this.property.getOwner() + " does not support queries");
        }
        this.table = persistence.getClassTable(this.property.getOwner());
        this.column = persistence.getPropertyColumn(this.property);
        String longName = this.property.getOwner().getName();
        this.className = longName.substring(longName.lastIndexOf(46) + 1);
    }

    public void addNeededTables(Set tableMap) {
        if (this.table != null) {
            tableMap.add(this.table);
        }
    }

    protected String getTable() {
        return this.table;
    }

    protected String getColumn() {
        return this.column;
    }

    public String getClassName() {
        return this.className;
    }

    public PropertiedObject.Property getProperty() {
        return this.property;
    }
}

