/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.sales.Customer;

public class FullTextSearch
implements QueryComponent {
    public static final Mode BOOLEAN_AND_MODE = new Mode(){

        @Override
        protected String parenthesizeTextToMatch(List wordsToMatch) {
            StringBuilder text = new StringBuilder();
            Iterator textIt = wordsToMatch.iterator();
            while (textIt.hasNext()) {
                text.append("+" + textIt.next().toString() + "* ");
            }
            return this.constructString("('", text.toString(), "' IN BOOLEAN MODE ) ");
        }

        public String toString() {
            return "Full-text searches using the IN BOOLEAN MODE for each words.";
        }
    };
    public static final Mode BOOLEAN_LITERAL = new Mode(){

        @Override
        protected String parenthesizeTextToMatch(List wordsToMatch) {
            StringBuilder text = new StringBuilder();
            Iterator textIt = wordsToMatch.iterator();
            while (textIt.hasNext()) {
                text.append(textIt.next().toString());
                if (!textIt.hasNext()) continue;
                text.append(" ");
            }
            return this.constructString("('+\"", text.toString(), "\"' IN BOOLEAN MODE ) ");
        }

        public String toString() {
            return "Full-text searches using the IN BOOLEAN MODE for the complete search string.";
        }
    };
    public static final Mode EXACT_MODE = new Mode(){

        @Override
        protected String parenthesizeTextToMatch(List wordsToMatch) {
            StringBuilder text = new StringBuilder();
            Iterator textIt = wordsToMatch.iterator();
            while (textIt.hasNext()) {
                text.append(textIt.next().toString() + " ");
            }
            return this.constructString("('", text.toString(), "')");
        }

        public String toString() {
            return "Natural Language Full-Text Searche.";
        }
    };
    public static final Mode WITH_QUERY_EXPANSION = new Mode(){

        @Override
        protected String parenthesizeTextToMatch(List wordsToMatch) {
            StringBuilder text = new StringBuilder();
            Iterator textIt = wordsToMatch.iterator();
            while (textIt.hasNext()) {
                text.append(textIt.next().toString());
                if (!textIt.hasNext()) continue;
                text.append(" ");
            }
            return this.constructString("('", text.toString(), "' WITH QUERY EXPANSION ) ");
        }

        public String toString() {
            return "Full-text searches using the WITH QUERY EXPANSION MODE for the complete search string.";
        }
    };
    private PropertiedObject.Property[] properties;
    private List textToMatch = new ArrayList();
    private FullTextIndex fullTextIndex;
    private Mode searchMode;
    private List tables = new ArrayList();
    private List columns = new ArrayList();

    public FullTextSearch(PropertiedObject.Property[] props, List text, FullTextIndex indexToUse) {
        this(props, text, indexToUse, BOOLEAN_AND_MODE);
    }

    public FullTextSearch(PropertiedObject.Property[] props, List text, FullTextIndex indexToUse, Mode modeToUse) {
        this.properties = props;
        this.textToMatch = text;
        this.fullTextIndex = indexToUse;
        this.searchMode = modeToUse;
    }

    @Override
    public void resolve(PersistenceMetaData persistence) throws QueryException {
        this.fullTextIndex.assertMatches(this.properties);
        this.tables.clear();
        this.columns.clear();
        for (int i = 0; i < this.properties.length; ++i) {
            PropertiedObject.Property prop = this.properties[i];
            String table = persistence.getClassTable(prop.getOwner());
            this.tables.add(table);
            this.columns.add(table + "." + persistence.getPropertyColumn(prop));
        }
    }

    public void addNeededTables(Set tableSet) {
        tableSet.addAll(this.tables);
    }

    @Override
    public String toString() {
        if (this.textToMatch.isEmpty()) {
            return " '1' ";
        }
        StringBuilder compSQL = new StringBuilder("MATCH (");
        Iterator columnsIt = this.columns.iterator();
        while (columnsIt.hasNext()) {
            compSQL.append(columnsIt.next());
            if (columnsIt.hasNext()) {
                compSQL.append(",");
                continue;
            }
            compSQL.append(") ");
        }
        compSQL.append(" AGAINST " + this.searchMode.parenthesizeTextToMatch(this.textToMatch));
        return compSQL.toString();
    }

    public static class FullTextIndex
    implements Serializable {
        public static final FullTextIndex CUSTOMER_NAME_INDEX = new FullTextIndex(new PropertiedObject.Property[]{Customer.Properties.FIRST_NAME, Customer.Properties.LAST_NAME, Customer.Properties.TITLE}, "Name");
        public static final FullTextIndex CUSTOMER_ADDRESS_INDEX = new FullTextIndex(new PropertiedObject.Property[]{Customer.Properties.STREET_NAME, Customer.Properties.SUBURB, Customer.Properties.POSTCODE, Customer.Properties.HOUSE_NUMBER, Customer.Properties.STATE, Customer.Properties.STREET_TYPE}, "Address");
        public static final FullTextIndex EVENT_LOG_TEXT = new FullTextIndex(new PropertiedObject.Property[]{EventLogRecord.Properties.TYPE, EventLogRecord.Properties.MESSAGE}, "Log");
        public static final FullTextIndex[] allIndexes = new FullTextIndex[]{CUSTOMER_NAME_INDEX, CUSTOMER_ADDRESS_INDEX, EVENT_LOG_TEXT};
        private final PropertiedObject.Property[] indexedProperties;
        private final String indexFieldName;

        private FullTextIndex(PropertiedObject.Property[] newIndexedProperties, String name) {
            this.indexedProperties = newIndexedProperties;
            this.indexFieldName = name;
        }

        public PropertiedObject.Property[] getIndexedProperties() {
            return this.indexedProperties;
        }

        public boolean matchesIndex(PropertiedObject.Property[] propertiesToCheck) {
            int i;
            if (propertiesToCheck.length != this.indexedProperties.length) {
                return false;
            }
            boolean isRegistered = false;
            for (i = 0; i < allIndexes.length; ++i) {
                if (!allIndexes[i].equals(this)) continue;
                isRegistered = true;
            }
            if (!isRegistered) {
                throw new QueryException("Full text index not registered in list of allIndexes");
            }
            for (i = 0; i < propertiesToCheck.length; ++i) {
                boolean isFound = false;
                for (int j = 0; j < this.indexedProperties.length; ++j) {
                    if (this.indexedProperties[j] != propertiesToCheck[i]) continue;
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                return false;
            }
            return true;
        }

        public void assertMatches(PropertiedObject.Property[] propertiesToCheck) {
            if (!this.matchesIndex(propertiesToCheck)) {
                StringBuilder message = new StringBuilder("No full text index exists that matches the properties to be matched against within a FullTextRestriction.\n " + this.toString() + "\nProperties to be search on: ");
                for (int i = 0; i < propertiesToCheck.length; ++i) {
                    message.append(propertiesToCheck[i].getLabel());
                    message.append("  ");
                }
                throw new QueryException(message.toString());
            }
        }

        public String toString() {
            StringBuilder string = new StringBuilder("Indexed properties: ");
            for (int i = 0; i < this.indexedProperties.length; ++i) {
                string.append(this.indexedProperties[i].getLabel());
                string.append(" ,");
            }
            return string.toString();
        }

        public boolean equals(Object value) {
            if (value != null && value instanceof FullTextIndex) {
                return Arrays.equals(((FullTextIndex)value).indexedProperties, this.indexedProperties);
            }
            return false;
        }

        public String getIndexFieldName() {
            return this.indexFieldName;
        }
    }

    public static abstract class Mode
    implements Serializable {
        private Mode() {
        }

        protected abstract String parenthesizeTextToMatch(List var1);

        protected String constructString(String prefix, String textToEscape, String suffix) {
            return prefix + StringUtils.escapeSingleQuotes(textToEscape) + suffix;
        }
    }
}

