/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Function
implements QueryComponent {
    private final String queryString;
    private String sqlString = "";
    private final List<String> neededTables = new ArrayList<String>();

    public Function(String newQueryString) {
        this.queryString = newQueryString;
    }

    public Function(String functionName, PropertiedObject.Property param) {
        this.queryString = functionName + "(" + param + ")";
    }

    public Function(String functionName, String param) {
        this.queryString = functionName + "(" + param + ")";
    }

    @Override
    public void resolve(PersistenceMetaData resolveUsing) throws QueryException {
        StringBuilder buffer = new StringBuilder();
        int index = 0;
        this.sqlString = "";
        this.neededTables.clear();
        while (index < this.queryString.length()) {
            if (this.queryString.indexOf(PropertiedObject.Property.class.getName() + "@", index) == -1) {
                buffer.append(this.queryString.substring(index));
                index = this.queryString.length();
                continue;
            }
            int propStart = this.queryString.indexOf(PropertiedObject.Property.class.getName() + "@", index);
            int propEnd = this.queryString.indexOf(93, propStart);
            String propString = this.queryString.substring(propStart, propEnd + 1);
            try {
                String tableCol = this.parseProp(propString, resolveUsing);
                buffer.append(this.queryString.substring(index, propStart) + tableCol);
                index = propEnd + 1;
            }
            catch (ClassNotFoundException e) {
                throw new QueryException("Could not parse property " + propString, e);
            }
        }
        this.sqlString = buffer.toString();
    }

    private String parseProp(String propString, PersistenceMetaData resolveUsing) throws ClassNotFoundException {
        int classStart = propString.indexOf("owner=") + 6;
        int classEnd = propString.indexOf(44, classStart);
        String className = propString.substring(classStart, classEnd);
        Class<?> ownerClass = Class.forName(className);
        String tableName = resolveUsing.getClassTable(ownerClass);
        int nameStart = propString.indexOf("name=", classEnd) + 5;
        int nameEnd = propString.indexOf(93, nameStart);
        String propertyName = propString.substring(nameStart, nameEnd);
        PropertiedObject.Property prop = new PropertiedObject.Property(ownerClass, propertyName);
        String colName = resolveUsing.getPropertyColumn(prop);
        this.neededTables.add(tableName);
        return tableName + "." + colName;
    }

    @Override
    public void addNeededTables(Set<String> tableMap) {
        tableMap.addAll(this.neededTables);
    }

    @Override
    public String toString() {
        return this.sqlString;
    }
}

