/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.Link;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Set;

public class LeftJoin
extends Link {
    private Class<? extends PersistentObjectI> tableClass;

    public LeftJoin(Class<? extends PersistentObjectI> persistentObjectClass, PropertiedObject.Property newLinkUsing) {
        super(newLinkUsing);
        this.tableClass = persistentObjectClass;
        this.ownerTable = PersistenceManager.getPersistenceMetaData().getClassTable(this.tableClass);
    }

    public void addNeededTables(Set tableMap) {
    }

    @Override
    protected void resolveFKReference(PersistenceMetaData persistence, PropertiedObject.Property resolveProperty) throws QueryException {
        this.checkQuerySupport(resolveProperty);
        if (!resolveProperty.getOwner().equals(this.tableClass)) {
            this.foreignTable = persistence.getClassTable(resolveProperty.getOwner());
            String fkColumn = persistence.getPropertyColumn(resolveProperty);
            this.sql = this.foreignTable + "." + fkColumn + " = " + this.ownerTable + ".ID";
        } else {
            this.foreignTable = persistence.getClassTable(resolveProperty.getObjectType());
            String fkColumn = persistence.getPropertyColumn(resolveProperty);
            this.sql = this.ownerTable + "." + fkColumn + " = " + this.foreignTable + ".ID";
        }
        this.appendSQL(persistence);
    }

    protected void checkQuerySupport(PropertiedObject.Property resolveProperty) throws QueryException {
        if (!PersistenceManager.getInstance().classSupportsQueries(resolveProperty.getOwner())) {
            throw new QueryException("Problem with select(Property).  Class " + resolveProperty.getOwner() + " does not support queries");
        }
        if (!PersistenceManager.getInstance().classSupportsQueries(resolveProperty.getObjectType())) {
            throw new QueryException("Problem with select(Property).  Class " + resolveProperty.getObjectType() + " does not support queries");
        }
    }

    private void appendSQL(PersistenceMetaData persistence) {
        StringBuilder SB = new StringBuilder("LEFT JOIN ");
        SB.append(persistence.getClassTable(this.tableClass));
        SB.append(" ON ");
        SB.append(this.sql);
        this.sql = SB.toString();
    }
}

