/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.LinkInterface;
import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Set;

class Link
implements QueryComponent,
LinkInterface {
    private final PropertiedObject.Property linkUsing;
    protected String ownerTable;
    protected String foreignTable;
    private String linkTable;
    protected String sql;

    public Link(PropertiedObject.Property newLinkUsing) {
        this.linkUsing = newLinkUsing;
    }

    @Override
    public String getOwnerTable() {
        return this.ownerTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resolve(PersistenceMetaData persistence) throws QueryException {
        if (this.linkUsing.isReference()) {
            this.resolveFKReference(persistence, this.linkUsing);
            return;
        } else {
            if (!this.linkUsing.isList()) throw new QueryException("The " + this.linkUsing + " property is not mapped to a Reference or List");
            PropertiedObject.Property linkBack = persistence.getOwnerProperty(this.linkUsing);
            if (linkBack == null) throw new QueryException(this.linkUsing + " does not have any mapping.");
            this.resolveFKReference(persistence, linkBack);
        }
    }

    protected void resolveFKReference(PersistenceMetaData persistence, PropertiedObject.Property resolveProperty) throws QueryException {
        if (!PersistenceManager.getInstance().classSupportsQueries(resolveProperty.getOwner())) {
            throw new QueryException("Problem with select(Property).  Class " + resolveProperty.getOwner() + " does not support queries");
        }
        this.ownerTable = persistence.getClassTable(resolveProperty.getOwner());
        String fkColumn = persistence.getPropertyColumn(resolveProperty);
        Class idClass = resolveProperty.getObjectType();
        if (!PersistenceManager.getInstance().classSupportsQueries(idClass)) {
            throw new QueryException("Problem with select(Property).  Class " + idClass + " does not support queries");
        }
        this.foreignTable = persistence.getClassTable(idClass);
        String idColumn = persistence.getPropertyColumn(new PropertiedObject.Property(idClass, PersistentObject.Properties.ID));
        this.sql = this.ownerTable + "." + fkColumn + " = " + this.foreignTable + "." + idColumn;
    }

    @Override
    public void addNeededTables(Set<String> tableMap) {
        tableMap.add(this.ownerTable);
        tableMap.add(this.foreignTable);
        if (this.linkTable != null) {
            tableMap.add(this.linkTable);
        }
    }

    @Override
    public void removeLinkedTables(Set<String> tableMap) {
        tableMap.remove(this.ownerTable);
        tableMap.remove(this.foreignTable);
        if (this.linkTable != null) {
            tableMap.remove(this.linkTable);
        }
    }

    @Override
    public String toString() {
        return this.sql;
    }
}

