/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Set;

class Multiplication
implements QueryComponent {
    private PropertiedObject.Property property1;
    private PropertiedObject.Property property2;
    private String col1;
    private String col2;
    private String table1;
    private String table2;
    private String name;

    public Multiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2) {
        this(prop1, prop2, null);
    }

    public Multiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2, String newName) {
        this.property1 = prop1;
        this.property2 = prop2;
        this.name = newName;
    }

    @Override
    public void resolve(PersistenceMetaData persistence) throws QueryException {
        if (!PersistenceManager.getInstance().classSupportsQueries(this.property1.getOwner())) {
            throw new QueryException("Problem with query component.  Class " + this.property1.getOwner() + " does not support queries");
        }
        this.table1 = persistence.getClassTable(this.property1.getOwner());
        this.col1 = persistence.getPropertyColumn(this.property1);
        if (!PersistenceManager.getInstance().classSupportsQueries(this.property2.getOwner())) {
            throw new QueryException("Problem with query component.  Class " + this.property2.getOwner() + " does not support queries");
        }
        this.table2 = persistence.getClassTable(this.property2.getOwner());
        this.col2 = persistence.getPropertyColumn(this.property2);
    }

    public void addNeededTables(Set tableMap) {
        tableMap.add(this.table1);
        tableMap.add(this.table2);
    }

    @Override
    public String toString() {
        String sql = "(" + this.table1 + "." + this.col1 + " * " + this.table2 + "." + this.col2 + ") as ";
        sql = this.name == null ? sql + "multiply_" + this.col1.toLowerCase() + "_by_" + this.col2.toLowerCase() : sql + this.name;
        return sql;
    }
}

