/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.Between;
import au.com.ordermate.oquery.Constant;
import au.com.ordermate.oquery.EndGroup;
import au.com.ordermate.oquery.From;
import au.com.ordermate.oquery.FullTextSearch;
import au.com.ordermate.oquery.FullTextSearchOrderBy;
import au.com.ordermate.oquery.Function;
import au.com.ordermate.oquery.FunctionRestriction;
import au.com.ordermate.oquery.Group;
import au.com.ordermate.oquery.GroupBy;
import au.com.ordermate.oquery.JoinFunction;
import au.com.ordermate.oquery.LeftJoin;
import au.com.ordermate.oquery.Limit;
import au.com.ordermate.oquery.Link;
import au.com.ordermate.oquery.LinkFunction;
import au.com.ordermate.oquery.LinkInterface;
import au.com.ordermate.oquery.LinkProperty;
import au.com.ordermate.oquery.Multiplication;
import au.com.ordermate.oquery.Not;
import au.com.ordermate.oquery.Or;
import au.com.ordermate.oquery.OrderBy;
import au.com.ordermate.oquery.OrderByInterface;
import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.oquery.QueryRestriction;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.SQLPeriodFunction;
import au.com.ordermate.oquery.SelectClass;
import au.com.ordermate.oquery.SelectCount;
import au.com.ordermate.oquery.SelectMath;
import au.com.ordermate.oquery.SelectProperty;
import au.com.ordermate.oquery.StringQueryComponent;
import au.com.ordermate.oquery.SubclassRestriction;
import au.com.ordermate.oquery.SumMultiplication;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import ordermate.OrderMate;

public class ObjectQuery
implements Serializable {
    private List<QueryComponent> select = new ArrayList<QueryComponent>();
    private List<LinkInterface> join = new ArrayList<LinkInterface>();
    private List<LinkInterface> linkWhere = new ArrayList<LinkInterface>();
    private List<QueryComponent> linkRestriction = new ArrayList<QueryComponent>();
    private List<QueryComponent> groupBy = new ArrayList<QueryComponent>();
    private List<QueryComponent> havingRestriction = new ArrayList<QueryComponent>();
    private List<OrderByInterface> orderBy = new ArrayList<OrderByInterface>();
    private List<Class> restrictionToAdd = new ArrayList<Class>();
    private List<From> froms;
    private String lastFrom;
    private Limit limit;
    private boolean distinct;
    private ObjectQuery unionChild = null;
    private ObjectQuery unionOwner;
    private boolean finishedBuilding;
    private String sql;
    private QueryException exception;
    private QueryComponent lastComponent;
    private int numGroup;
    private int numEndGroup;
    private List<String> unionSQL;
    private PersistenceMetaData metaData;

    public ObjectQuery() {
    }

    public ObjectQuery copy() {
        return new ObjectQuery(this);
    }

    protected ObjectQuery(ObjectQuery copy) {
        this.select = new ArrayList<QueryComponent>(copy.select);
        this.join = new ArrayList<LinkInterface>(copy.join);
        this.linkWhere = new ArrayList<LinkInterface>(copy.linkWhere);
        this.linkRestriction = new ArrayList<QueryComponent>(copy.linkRestriction);
        this.groupBy = new ArrayList<QueryComponent>(copy.groupBy);
        this.havingRestriction = new ArrayList<QueryComponent>(copy.havingRestriction);
        this.orderBy = new ArrayList<OrderByInterface>(copy.orderBy);
        this.restrictionToAdd = new ArrayList<Class>(copy.restrictionToAdd);
        this.lastFrom = copy.lastFrom;
        this.limit = copy.limit;
        this.distinct = copy.distinct;
        if (copy.froms != null) {
            this.froms = new ArrayList<From>(copy.froms);
        }
        if (copy.unionChild != null) {
            ObjectQuery owner = copy.unionChild.unionOwner;
            copy.unionChild.unionOwner = null;
            this.unionChild = new ObjectQuery(copy.unionChild);
            copy.unionChild.unionOwner = owner;
            this.unionChild.unionOwner = this;
        } else {
            this.unionChild = null;
        }
        if (copy.unionOwner != null) {
            ObjectQuery child = copy.unionOwner.unionChild;
            copy.unionOwner.unionChild = null;
            this.unionOwner = new ObjectQuery(copy.unionOwner);
            copy.unionOwner.unionChild = child;
            this.unionOwner.unionChild = this;
        } else {
            this.unionOwner = null;
        }
        this.finishedBuilding = copy.finishedBuilding;
        this.sql = copy.sql;
        this.exception = copy.exception;
        this.lastComponent = copy.lastComponent;
        this.numGroup = copy.numGroup;
        this.numEndGroup = copy.numEndGroup;
        this.unionSQL = copy.unionSQL;
    }

    public ObjectQuery select(Class toSelect) {
        this.checkFinished();
        this.select.add(new SelectClass(toSelect));
        this.restrictionToAdd.add(toSelect);
        return this;
    }

    public ObjectQuery select(PropertiedObject.Property property) {
        this.checkFinished();
        this.select.add(new SelectProperty(property));
        this.restrictionToAdd.add(property.getOwner());
        return this;
    }

    public ObjectQuery select(PropertiedObject.Property property, String name) {
        this.checkFinished();
        this.select.add(new SelectProperty(property, name));
        return this;
    }

    public ObjectQuery select(double toSelect) {
        this.checkFinished();
        this.select.add(new Constant(Double.toString(toSelect)));
        return this;
    }

    public ObjectQuery select(double toSelect, String colName) {
        this.checkFinished();
        this.select.add(new Constant(Double.toString(toSelect), colName));
        return this;
    }

    public ObjectQuery select(String toSelect) {
        this.checkFinished();
        this.select.add(new Constant("'" + toSelect + "'"));
        return this;
    }

    public ObjectQuery select(String toSelect, String colName) {
        this.checkFinished();
        this.select.add(new Constant("'" + toSelect + "'", colName));
        return this;
    }

    public ObjectQuery selectID() {
        this.checkFinished();
        this.select.add(new Constant("ID"));
        return this;
    }

    public ObjectQuery selectFunc(String queryString) {
        this.checkFinished();
        this.select.add(new Function(queryString));
        return this;
    }

    public ObjectQuery from(String from, String alias) {
        this.checkFinished();
        if (this.froms == null) {
            this.froms = new ArrayList<From>();
        }
        this.froms.add(new From(from, alias));
        return this;
    }

    public ObjectQuery sum(PropertiedObject.Property property) {
        this.checkFinished();
        this.select.add(new SelectMath(property, "Sum"));
        return this;
    }

    public ObjectQuery sum(PropertiedObject.Property property, String name) {
        this.checkFinished();
        this.select.add(new SelectMath(property, "Sum", name));
        return this;
    }

    public ObjectQuery min(PropertiedObject.Property property, String name) {
        this.checkFinished();
        this.select.add(new SelectMath(property, "MIN", name));
        return this;
    }

    public ObjectQuery max(PropertiedObject.Property property, String name) {
        this.checkFinished();
        this.select.add(new SelectMath(property, "MAX", name));
        return this;
    }

    public ObjectQuery sumMultiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2) {
        this.checkFinished();
        this.select.add(new SumMultiplication(prop1, prop2));
        return this;
    }

    public ObjectQuery sumMultiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2, String name) {
        this.checkFinished();
        this.select.add(new SumMultiplication(prop1, prop2, name));
        return this;
    }

    public ObjectQuery sumMultiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2, String name, boolean nullSafe) {
        this.checkFinished();
        this.select.add(new SumMultiplication(prop1, prop2, name, nullSafe));
        return this;
    }

    public ObjectQuery multiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2) {
        this.checkFinished();
        this.select.add(new Multiplication(prop1, prop2));
        return this;
    }

    public ObjectQuery multiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2, String name) {
        this.checkFinished();
        this.select.add(new Multiplication(prop1, prop2, name));
        return this;
    }

    public ObjectQuery count(Class toCount) {
        this.checkFinished();
        this.select.add(new SelectCount(toCount));
        return this;
    }

    public ObjectQuery count(Class toCount, String name) {
        this.checkFinished();
        this.select.add(new SelectCount(toCount, name));
        return this;
    }

    public ObjectQuery avg(PropertiedObject.Property property) {
        this.checkFinished();
        this.select.add(new SelectMath(property, "Avg"));
        return this;
    }

    public ObjectQuery avg(PropertiedObject.Property property, String name) {
        this.checkFinished();
        this.select.add(new SelectMath(property, "Avg", name));
        return this;
    }

    public ObjectQuery clearSelect() {
        this.select.clear();
        return this;
    }

    public ObjectQuery clearGroupBy() {
        this.groupBy.clear();
        return this;
    }

    public ObjectQuery clearOrderBy() {
        this.orderBy.clear();
        return this;
    }

    public ObjectQuery joinLeft(Class<? extends PersistentObjectI> persistentClass, PropertiedObject.Property property) {
        this.join.add(new LeftJoin(persistentClass, property));
        return this;
    }

    public ObjectQuery joinFunction(String joinPart) {
        this.join.add(new JoinFunction(joinPart));
        return this;
    }

    public ObjectQuery joinFunction(String joinPart, Class<? extends PersistentObjectI> linkedOwner) {
        this.join.add(new JoinFunction(joinPart, linkedOwner));
        return this;
    }

    public ObjectQuery linkUsing(PropertiedObject.Property property) {
        this.checkFinished();
        this.linkWhere.add(new Link(property));
        return this;
    }

    public ObjectQuery linkUsing(PropertiedObject.Property property, PropertiedObject.Property otherProp) {
        this.checkFinished();
        this.linkWhere.add(new LinkProperty(property, otherProp));
        return this;
    }

    public ObjectQuery linkUsing(String ownerTable, String foreignTable) {
        this.checkFinished();
        this.linkWhere.add(new LinkFunction(ownerTable, foreignTable));
        return this;
    }

    public ObjectQuery linkUsing(String ownerTable, String joinColumn, String foreignTable) {
        this.checkFinished();
        this.linkWhere.add(new LinkFunction(ownerTable, joinColumn, foreignTable));
        return this;
    }

    public ObjectQuery linkUsing(String ownerTable, String joinColumn, String foreignTable, String foreignColumn) {
        this.checkFinished();
        this.linkWhere.add(new LinkFunction(ownerTable, joinColumn, foreignTable, foreignColumn));
        return this;
    }

    @Deprecated
    public ObjectQuery equals(PropertiedObject.Property property, boolean value) {
        if (value) {
            throw new IllegalArgumentException("Does not work with true");
        }
        return this.equals(property, Boolean.FALSE);
    }

    public ObjectQuery equals(PropertiedObject.Property property, double value) {
        return this.equals(property, new Double(value));
    }

    public ObjectQuery equals(PropertiedObject.Property property, Object value) {
        this.addRestriction(new QueryRestriction(property, "=", value));
        return this;
    }

    @Deprecated
    public ObjectQuery equals(PropertiedObject.Property<java.util.Date> prop, java.util.Date date) {
        throw new IllegalArgumentException("Method deprecated use, equals(Prop, Date, SQLDateType)");
    }

    public ObjectQuery equals(PropertiedObject.Property property, java.util.Date date, SQLDateType type) {
        return this.equals(property, ObjectQuery.convertToSQLType(date, type));
    }

    public static Object convertToSQLType(java.util.Date date, SQLDateType type) {
        switch (type) {
            case TIMESTAMP: {
                java.util.Date truncateMilli = new java.util.Date(date.getYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
                return new Timestamp(truncateMilli.getTime());
            }
            case DATE: {
                return new Date(date.getTime());
            }
            case TIME: {
                return new Time(date.getTime());
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + " is an unhandled SQLDateType");
    }

    public ObjectQuery equals(PropertiedObject.Property property, Object value, boolean literal) {
        this.addRestriction(new QueryRestriction(property, "=", value, literal));
        return this;
    }

    public ObjectQuery equals(PropertiedObject.Property property, Object value, String havingAlias) {
        QueryRestriction newHavingRestriction = new QueryRestriction(property, "=", value);
        newHavingRestriction.setAlias(havingAlias);
        this.addHavingRestriction(newHavingRestriction);
        return this;
    }

    public ObjectQuery active(Class<? extends PropertiedObject> isActive) {
        return this.equals(new PropertiedObject.Property(isActive, "systemState"), "ACTIVE");
    }

    public ObjectQuery inactive(Class<? extends PropertiedObject> isInactive) {
        return this.equals(new PropertiedObject.Property(isInactive, "systemState"), "INACTIVE");
    }

    public ObjectQuery deleted(Class<? extends PropertiedObject> isDeleted) {
        return this.equals(new PropertiedObject.Property(isDeleted, "systemState"), "DELETED");
    }

    public ObjectQuery equalsParam(PropertiedObject.Property property) {
        this.addRestriction(new QueryRestriction(property, "="));
        return this;
    }

    public ObjectQuery isNull(PropertiedObject.Property property) {
        this.addRestriction(new QueryRestriction(property, "=", null));
        return this;
    }

    public ObjectQuery greaterThan(PropertiedObject.Property property, double value) {
        return this.greaterThan(property, new Double(value));
    }

    public ObjectQuery greaterThan(PropertiedObject.Property property, Object value) {
        this.addRestriction(new QueryRestriction(property, ">", value));
        return this;
    }

    @Deprecated
    public ObjectQuery greaterThan(PropertiedObject.Property property, java.util.Date value) {
        throw new IllegalStateException("Method is deprecated, use the overloaded method that takes an SQLDateType");
    }

    public ObjectQuery greaterThan(PropertiedObject.Property property, java.util.Date value, SQLDateType type) {
        return this.greaterThan(property, ObjectQuery.convertToSQLType(value, type));
    }

    public ObjectQuery greaterThanOrEqual(PropertiedObject.Property property, Object value) {
        this.addRestriction(new QueryRestriction(property, ">=", value));
        return this;
    }

    @Deprecated
    public ObjectQuery greaterThanOrEqual(PropertiedObject.Property property, java.util.Date date) {
        throw new IllegalStateException("Method is deprecated, use the overloaded method that takes an SQLDateType");
    }

    public ObjectQuery greaterThanOrEqual(PropertiedObject.Property property, java.util.Date date, SQLDateType type) {
        return this.greaterThanOrEqual(property, ObjectQuery.convertToSQLType(date, type));
    }

    public ObjectQuery greaterThanParam(PropertiedObject.Property property) {
        this.addRestriction(new QueryRestriction(property, ">"));
        return this;
    }

    public ObjectQuery lessThan(PropertiedObject.Property property, Object value) {
        this.addRestriction(new QueryRestriction(property, "<", value));
        return this;
    }

    @Deprecated
    public ObjectQuery lessThan(PropertiedObject.Property<java.util.Date> property, java.util.Date date) {
        throw new IllegalStateException("Method is deprecated, use the overloaded method that takes an SQLDateType");
    }

    public ObjectQuery lessThan(PropertiedObject.Property<?> property, java.util.Date date, SQLDateType type) {
        return this.lessThan(property, ObjectQuery.convertToSQLType(date, type));
    }

    public ObjectQuery lessThan(PropertiedObject.Property property, double value) {
        return this.lessThan(property, new Double(value));
    }

    public ObjectQuery lessThanOrEqual(PropertiedObject.Property property, Object value) {
        this.addRestriction(new QueryRestriction(property, "<=", value));
        return this;
    }

    @Deprecated
    public ObjectQuery lessThanOrEqual(PropertiedObject.Property p, java.util.Date d) {
        throw new IllegalStateException("Method is deprecated, use the overloaded method that takes an SQLDateType");
    }

    public ObjectQuery lessThanOrEqual(PropertiedObject.Property property, java.util.Date date, SQLDateType type) {
        return this.lessThanOrEqual(property, ObjectQuery.convertToSQLType(date, type));
    }

    public ObjectQuery lessThanParam(PropertiedObject.Property property) {
        this.addRestriction(new QueryRestriction(property, "<"));
        return this;
    }

    public ObjectQuery startsWith(PropertiedObject.Property property, String value) {
        this.addRestriction(new QueryRestriction(property, "LIKE", value + "%"));
        return this;
    }

    public ObjectQuery wherePropertyLike(PropertiedObject.Property property, String value) {
        this.addRestriction(new QueryRestriction(property, "LIKE", "%" + value + "%"));
        return this;
    }

    public ObjectQuery wherePropsInFullTextSearch(PropertiedObject.Property[] props, String text, FullTextSearch.FullTextIndex index) {
        return this.wherePropsInFullTextSearch(props, text, index, true);
    }

    public ObjectQuery wherePropsInFullTextSearch(PropertiedObject.Property[] props, String text, FullTextSearch.FullTextIndex index, boolean orderByRelevance) {
        return this.wherePropsInFullTextSearch(props, text, index, FullTextSearch.BOOLEAN_AND_MODE, orderByRelevance);
    }

    public ObjectQuery wherePropsInFullTextSearch(String text, FullTextSearch.FullTextIndex index, FullTextSearch.Mode mode) {
        return this.wherePropsInFullTextSearch(index.getIndexedProperties(), text, index, mode, true);
    }

    public ObjectQuery wherePropsInFullTextSearch(PropertiedObject.Property[] props, String text, FullTextSearch.FullTextIndex index, FullTextSearch.Mode mode, boolean orderByRelevance) {
        String[] words = text.split(" ");
        this.addRestriction(new FullTextSearch(props, Arrays.asList(words), index, mode));
        if (orderByRelevance) {
            this.orderBy(new FullTextSearchOrderBy(props, Arrays.asList(words), index));
        }
        return this;
    }

    public ObjectQuery wherePropertyIn(PropertiedObject.Property<?> property, Collection objects) {
        this.addRestriction(new QueryRestriction(property, objects));
        return this;
    }

    public ObjectQuery wherePropertyIn(PropertiedObject.Property<?> property, Object[] objects) {
        return this.wherePropertyIn(property, new ArrayList<Object>(Arrays.asList(objects)));
    }

    public ObjectQuery whereIn(String columnName, List selectedOptions) {
        this.addRestriction(new QueryRestriction(columnName, (Collection)selectedOptions));
        return this;
    }

    public ObjectQuery whereFunction(String function) {
        this.addRestriction(new Function(function));
        return this;
    }

    public ObjectQuery whereFunctionEquals(SQLPeriodFunction function, PropertiedObject.Property prop, Object value) {
        this.addRestriction(new FunctionRestriction(prop, "=", value, function.toString(), function.toString()));
        return this;
    }

    public ObjectQuery wherePropertyBetween(PropertiedObject.Property property, Object lowerBound, Object upperBound) {
        if (lowerBound != null && upperBound != null && lowerBound instanceof Comparable && upperBound instanceof Comparable && ((Comparable)lowerBound).compareTo(upperBound) > 0) {
            this.addRestriction(new Between(property, upperBound, lowerBound));
        } else {
            this.addRestriction(new Between(property, lowerBound, upperBound));
        }
        return this;
    }

    @Deprecated
    public ObjectQuery wherePropertyBetween(PropertiedObject.Property prop, java.util.Date lower, java.util.Date upper) {
        throw new IllegalStateException("Method is deprecated use wherePropertyBetween(Property prop, Date lower, Date upper, SQLDateType type");
    }

    public ObjectQuery wherePropertyBetween(PropertiedObject.Property prop, java.util.Date lower, java.util.Date upper, SQLDateType type) {
        return this.wherePropertyBetween(prop, ObjectQuery.convertToSQLType(lower, type), ObjectQuery.convertToSQLType(upper, type));
    }

    public ObjectQuery havingPropertyBetween(PropertiedObject.Property property, Object lowerBound, Object upperBound, String alias) {
        Between statement = new Between(property, lowerBound, upperBound);
        statement.setAlias(alias);
        this.addHavingRestriction(statement);
        return this;
    }

    public ObjectQuery havingPropertyBetween(PropertiedObject.Property prop, java.util.Date lower, java.util.Date upper, SQLDateType type, String alias) {
        return this.havingPropertyBetween(prop, ObjectQuery.convertToSQLType(lower, type), ObjectQuery.convertToSQLType(upper, type), alias);
    }

    public ObjectQuery havingFunction(String function) {
        this.addHavingRestriction(new Function(function));
        return this;
    }

    public ObjectQuery whereSubclassIsOneOf(List subclasses) {
        if (subclasses == null || subclasses.size() == 0) {
            return this;
        }
        this.group();
        Iterator it = subclasses.iterator();
        while (it.hasNext()) {
            this.addRestriction(new SubclassRestriction((Class)it.next()));
            if (!it.hasNext()) continue;
            this.or();
        }
        this.endGroup();
        return this;
    }

    public ObjectQuery instanceOf(Class type) {
        this.addRestriction(new SubclassRestriction(type));
        return this;
    }

    public ObjectQuery or() {
        if (this.linkRestriction.isEmpty()) {
            this.addRestriction(new Or(null));
        } else {
            QueryComponent last = this.linkRestriction.remove(this.linkRestriction.size() - 1);
            this.addRestriction(new Or(last));
        }
        return this;
    }

    public ObjectQuery not() {
        this.addRestriction(new Not());
        return this;
    }

    public ObjectQuery group() {
        this.addRestriction(new Group());
        ++this.numGroup;
        return this;
    }

    public ObjectQuery endGroup() {
        QueryComponent last = this.linkRestriction.remove(this.linkRestriction.size() - 1);
        this.addRestriction(new EndGroup(last));
        ++this.numEndGroup;
        return this;
    }

    private void addRestriction(QueryComponent toAdd) {
        this.checkFinished();
        if (this.lastComponent instanceof Or) {
            Or or = (Or)this.lastComponent;
            or.setRightSide(toAdd);
        } else if (this.lastComponent instanceof Not) {
            Not not = (Not)this.lastComponent;
            not.setOperation(toAdd);
        } else if (this.lastComponent instanceof Group) {
            Group group = (Group)this.lastComponent;
            group.setOperation(toAdd);
        } else {
            this.linkRestriction.add(toAdd);
        }
        this.lastComponent = toAdd;
    }

    private void addHavingRestriction(QueryComponent toAdd) {
        this.checkFinished();
        this.havingRestriction.add(toAdd);
        this.lastComponent = toAdd;
    }

    public ObjectQuery orderBy(PropertiedObject.Property property) {
        this.checkFinished();
        this.orderBy.add(new OrderBy(property, false));
        return this;
    }

    public ObjectQuery orderBy(PropertiedObject.Property property, boolean desc) {
        this.checkFinished();
        this.orderBy.add(new OrderBy(property, desc));
        return this;
    }

    public ObjectQuery orderBy(OrderByInterface orderByClause) {
        this.checkFinished();
        this.orderBy.add(orderByClause);
        return this;
    }

    public ObjectQuery orderBy(String column, boolean desc) {
        this.checkFinished();
        if (desc) {
            this.orderBy.add(new StringQueryComponent(column + " DESC"));
        } else {
            this.orderBy.add(new StringQueryComponent(column));
        }
        return this;
    }

    public ObjectQuery orderByDesc(PropertiedObject.Property property) {
        this.checkFinished();
        this.orderBy.add(new OrderBy(property, true));
        return this;
    }

    public ObjectQuery groupBy(PropertiedObject.Property toGroupBy) {
        this.checkFinished();
        this.groupBy.add(new GroupBy(toGroupBy));
        return this;
    }

    public ObjectQuery groupBy(GroupBy toGroupBy) {
        this.checkFinished();
        this.groupBy.add(toGroupBy);
        return this;
    }

    public ObjectQuery groupBy(String toGroupBy) {
        this.checkFinished();
        this.groupBy.add(new Function(toGroupBy));
        return this;
    }

    public ObjectQuery groupBy(SQLPeriodFunction periodGroupBy, PropertiedObject.Property prop) {
        this.checkFinished();
        this.groupBy.add(new Function(periodGroupBy.toString(), prop));
        return this;
    }

    public ObjectQuery groupBy(SQLPeriodFunction periodGroupBy, String parameter) {
        this.checkFinished();
        this.groupBy.add(new Function(periodGroupBy.toString(), parameter));
        return this;
    }

    public ObjectQuery distinct() {
        this.checkFinished();
        this.distinct = true;
        return this;
    }

    public ObjectQuery limit(int limitNum) {
        this.checkFinished();
        this.limit = new Limit(limitNum);
        return this;
    }

    public ObjectQuery limit(int limitNum, int offset) {
        this.checkFinished();
        this.limit = new Limit(limitNum, offset);
        return this;
    }

    public ObjectQuery union() {
        this.unionChild = new ObjectQuery();
        this.unionChild.unionOwner = this;
        return this.unionChild;
    }

    public ObjectQuery union(ObjectQuery toJoin) {
        this.unionChild = toJoin;
        this.unionChild.unionOwner = this;
        return this.unionChild;
    }

    public ObjectQuery union(String newSql) {
        if (this.unionSQL == null) {
            this.unionSQL = new ArrayList<String>();
        }
        this.unionSQL.add(newSql);
        return this;
    }

    private void checkFinished() {
        if (this.finishedBuilding) {
            throw new IllegalStateException("Query building is finished.  Do not add to the query after toString has been called");
        }
    }

    private void generateSql() {
        if (!this.finishedBuilding) {
            PersistenceMetaData p = this.metaData == null ? PersistenceManager.getPersistenceMetaData() : this.metaData;
            for (Class claxx : this.restrictionToAdd) {
                if (!p.classSupportsQueries(claxx.getSuperclass())) continue;
                this.addRestriction(new SubclassRestriction(claxx));
            }
            ArrayList<QueryComponent> allComponents = new ArrayList<QueryComponent>(this.select.size());
            allComponents.addAll(this.select);
            allComponents.addAll(this.linkWhere);
            allComponents.addAll(this.join);
            allComponents.addAll(this.linkRestriction);
            allComponents.addAll(this.groupBy);
            allComponents.addAll(this.havingRestriction);
            allComponents.addAll(this.orderBy);
            LinkedHashSet<String> fromTables = new LinkedHashSet<String>();
            try {
                for (QueryComponent component : allComponents) {
                    component.resolve(p);
                    component.addNeededTables(fromTables);
                }
            }
            catch (QueryException e) {
                this.exception = e;
                this.finishedBuilding = true;
                throw e;
            }
            if (fromTables.size() > 1) {
                LinkedHashSet<String> unlinkedTables = new LinkedHashSet<String>(fromTables);
                LinkedHashSet<LinkInterface> linkSet = new LinkedHashSet<LinkInterface>(this.linkWhere.size() + this.join.size());
                linkSet.addAll(this.linkWhere);
                linkSet.addAll(this.join);
                for (LinkInterface linkInterface : linkSet) {
                    linkInterface.removeLinkedTables(unlinkedTables);
                }
                if (!unlinkedTables.isEmpty()) {
                    this.exception = new QueryException("The following tables have not been properly linked " + unlinkedTables);
                    throw this.exception;
                }
            }
            if (this.numGroup > this.numEndGroup) {
                this.exception = new QueryException("group() has been left open.  You need to call endGroup()");
                throw this.exception;
            }
            if (this.numEndGroup > this.numGroup) {
                this.exception = new QueryException("Too many endGroup() calls.  You need to remove some, or add group()");
                throw this.exception;
            }
            StringBuffer sqlBuffer = new StringBuffer("SELECT");
            if (this.distinct) {
                sqlBuffer.append(" DISTINCT\n");
            } else {
                sqlBuffer.append("\n");
            }
            Iterator<Object> it = this.select.iterator();
            while (it.hasNext()) {
                QueryComponent selectComponent = it.next();
                sqlBuffer.append("   ");
                String string = selectComponent.toString();
                if (string.equals("")) {
                    throw new IllegalStateException("Component was empty. " + selectComponent.getClass().getSimpleName() + " : " + this);
                }
                sqlBuffer.append(selectComponent.toString());
                if (!it.hasNext()) continue;
                sqlBuffer.append(",\n");
            }
            for (LinkInterface linkInterface : this.join) {
                fromTables.remove(linkInterface.getOwnerTable());
            }
            if (this.lastFrom != null) {
                fromTables.remove(this.lastFrom);
                fromTables.add(this.lastFrom);
            }
            LinkedHashSet<String> fromSet = new LinkedHashSet<String>();
            fromSet.addAll(fromTables);
            if (this.froms != null) {
                for (From from : this.froms) {
                    fromSet.remove(from.getAlias());
                    fromSet.add(from.toString());
                }
            }
            if (!fromSet.isEmpty()) {
                sqlBuffer.append("\nFROM ");
                it = fromSet.iterator();
                while (it.hasNext()) {
                    String string = (String)((Object)it.next());
                    sqlBuffer.append(string);
                    if (!it.hasNext()) continue;
                    sqlBuffer.append(", ");
                }
            } else {
                OrderMate.LOG.warn("From set is empty for query " + sqlBuffer);
            }
            if (!this.join.isEmpty()) {
                sqlBuffer.append("\n");
                it = this.join.iterator();
                for (LinkInterface linkInterface : this.join) {
                    sqlBuffer.append("   ");
                    sqlBuffer.append(linkInterface.toString());
                    if (!it.hasNext()) continue;
                    sqlBuffer.append("\n");
                }
            }
            if (!this.linkWhere.isEmpty() || !this.linkRestriction.isEmpty()) {
                sqlBuffer.append("\nWHERE\n");
                it = this.linkWhere.iterator();
                while (it.hasNext()) {
                    QueryComponent queryComponent = it.next();
                    String string = queryComponent.toString();
                    if (string.isEmpty()) continue;
                    sqlBuffer.append("   ");
                    sqlBuffer.append(string);
                    if (!it.hasNext() && this.linkRestriction.isEmpty()) continue;
                    sqlBuffer.append(" AND\n");
                }
                it = this.linkRestriction.iterator();
                while (it.hasNext()) {
                    QueryComponent queryComponent = it.next();
                    String string = queryComponent.toString();
                    if (string.isEmpty()) continue;
                    sqlBuffer.append("   ");
                    sqlBuffer.append(queryComponent.toString());
                    if (!it.hasNext()) continue;
                    sqlBuffer.append(" AND\n");
                }
            }
            if (!this.groupBy.isEmpty()) {
                sqlBuffer.append("\nGROUP BY ");
                it = this.groupBy.iterator();
                while (it.hasNext()) {
                    QueryComponent queryComponent = it.next();
                    sqlBuffer.append(queryComponent.toString());
                    if (!it.hasNext()) continue;
                    sqlBuffer.append(", ");
                }
            }
            if (!this.havingRestriction.isEmpty()) {
                sqlBuffer.append("\nHAVING\n");
                it = this.havingRestriction.iterator();
                while (it.hasNext()) {
                    QueryComponent queryComponent = it.next();
                    sqlBuffer.append("   ");
                    sqlBuffer.append(queryComponent.toString());
                    if (!it.hasNext()) continue;
                    sqlBuffer.append(" AND\n");
                }
            }
            if (!this.orderBy.isEmpty()) {
                sqlBuffer.append('\n');
                sqlBuffer.append("ORDER BY ");
                it = this.orderBy.iterator();
                while (it.hasNext()) {
                    QueryComponent queryComponent = (QueryComponent)it.next();
                    sqlBuffer.append(queryComponent.toString());
                    if (!it.hasNext()) continue;
                    sqlBuffer.append(", ");
                }
            }
            if (this.limit != null) {
                sqlBuffer.append('\n');
                sqlBuffer.append(this.limit);
            }
            if (this.unionSQL != null) {
                for (String string : this.unionSQL) {
                    sqlBuffer.append("\n\nUNION\n\n");
                    sqlBuffer.append(string);
                }
            }
            if (this.unionChild != null) {
                this.unionChild.generateSql();
                if (this.exception == null && this.unionChild.exception != null) {
                    this.exception = this.unionChild.exception;
                } else {
                    sqlBuffer.append("\n\nUNION\n\n");
                    sqlBuffer.append(this.unionChild.sql);
                }
            }
            this.finishedBuilding = true;
            this.sql = sqlBuffer.toString();
        }
    }

    public String toString() {
        if (this.unionOwner != null) {
            return this.unionOwner.toString();
        }
        if (!this.finishedBuilding) {
            this.generateSql();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.sql;
    }

    protected void setFinishedBuilding() {
        this.finishedBuilding = true;
    }

    public boolean equals(Object query) {
        if (!(query instanceof ObjectQuery)) {
            return false;
        }
        ObjectQuery otherQuery = (ObjectQuery)query;
        if (!this.finishedBuilding || !otherQuery.finishedBuilding) {
            return super.equals(otherQuery);
        }
        return this.toString().equals(otherQuery.toString());
    }

    public int hashCode() {
        if (this.finishedBuilding) {
            return this.toString().hashCode();
        }
        return super.hashCode();
    }

    public List<QueryComponent> getSelects() {
        return Collections.unmodifiableList(this.select);
    }

    public List<QueryComponent> getHavings() {
        return Collections.unmodifiableList(this.havingRestriction);
    }

    public ObjectQuery isStringEmpty(PropertiedObject.Property property) {
        this.addRestriction(new QueryRestriction(property, "=", ""));
        return this;
    }

    public ObjectQuery lastFrom(String lastTable) {
        this.checkFinished();
        this.lastFrom = lastTable;
        return this;
    }

    public ObjectQuery setMetaData(PersistenceMetaData newMetaData) {
        this.metaData = newMetaData;
        return this;
    }

    public void replaceSelect(QueryComponent component, String replaceSelect, String as) {
        this.select.set(this.select.indexOf(component), new Constant(replaceSelect, as));
    }

    public void removeSelect(QueryComponent comp) {
        this.select.remove(comp);
    }
}

