/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.OrderBy;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.sql.queries.Literal;
import au.com.ordermate.sql.queries.Operator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ObjectSearcher {
    private static final int LIMIT_TO_ROWS = 100;
    private Class selectClass;
    private PropertiedObject.Property selectProp;
    private Map propertyValues = new HashMap();
    private Map equivalentProps = new HashMap();
    private List orderByProps = new ArrayList();

    public ObjectSearcher(Class searchType) {
        this.selectClass = searchType;
    }

    public ObjectSearcher(PropertiedObject.Property searchProp) {
        this.selectProp = searchProp;
    }

    public void addEquivalentGroup(PropertiedObject.Property firstProp, PropertiedObject.Property equivalentProp) {
        this.equivalentProps.put(firstProp, equivalentProp);
        this.equivalentProps.put(equivalentProp, firstProp);
    }

    public void addOrderBy(PropertiedObject.Property orderBy) {
        this.orderByProps.add(orderBy);
    }

    public void setPropertyValue(PropertiedObject.Property prop, String value) {
        if (value == null || value.equals("")) {
            this.propertyValues.remove(prop);
        } else {
            this.propertyValues.put(prop, value);
        }
    }

    public void clearPropertyValue() {
        this.propertyValues.clear();
    }

    public List getMatches() {
        List results;
        ObjectQuery query = null;
        ObjectQuery secondQuery = null;
        PropertiedObject.Property secondQueryProp = null;
        if (this.selectClass != null) {
            query = Query.select(this.selectClass);
        } else {
            query = Query.select(this.selectProp);
            if (this.equivalentProps.containsKey(this.selectProp)) {
                PropertiedObject.Property secondProp;
                secondQueryProp = secondProp = (PropertiedObject.Property)this.equivalentProps.get(this.selectProp);
                secondQuery = Query.select(secondProp);
                secondQuery.limit(100);
                secondQuery.distinct();
            }
        }
        query.limit(100);
        query.distinct();
        for (PropertiedObject.Property prop : this.propertyValues.keySet()) {
            String value = (String)this.propertyValues.get(prop);
            if (this.equivalentProps.containsKey(prop)) {
                PropertiedObject.Property equivalent = (PropertiedObject.Property)this.equivalentProps.get(prop);
                if (secondQuery != null) {
                    if (prop.equals(this.selectProp)) {
                        query.wherePropertyLike(prop, value);
                        secondQuery.wherePropertyLike(equivalent, value);
                    } else if (prop.equals(secondQueryProp)) {
                        query.wherePropertyLike(equivalent, value);
                        secondQuery.wherePropertyLike(prop, value);
                    } else {
                        secondQuery.group().wherePropertyLike(prop, value).or().wherePropertyLike(equivalent, value).endGroup();
                        query.group().wherePropertyLike(prop, value).or().wherePropertyLike(equivalent, value).endGroup();
                    }
                } else {
                    query.group().wherePropertyLike(prop, value).or().wherePropertyLike(equivalent, value).endGroup();
                }
            } else {
                query.wherePropertyLike(prop, value);
                if (secondQuery != null) {
                    secondQuery.wherePropertyLike(prop, value);
                }
            }
            if (this.orderByProps.size() != 0) continue;
            query.orderBy(new OrderBy(prop, Operator.LIKE, Literal.getAddQuotes(value + "%"), true));
            query.orderBy(prop);
        }
        for (PropertiedObject.Property prop : this.orderByProps) {
            query.orderBy(prop);
            if (secondQuery == null) continue;
            secondQuery.orderBy(prop);
        }
        String sql = query.toString();
        if (this.selectClass != null) {
            results = PersistenceManager.getObjectList(this.selectClass, sql, new Object[0]);
        } else {
            Object[][] array = PersistenceManager.getPersistenceDelegate().executeQuery(sql, new Object[0]);
            results = new ArrayList(array.length);
            HashSet<Object> firstQueryResults = new HashSet<Object>();
            for (int i = 0; i < array.length; ++i) {
                if (array[i][0] == null) continue;
                results.add(array[i][0]);
                firstQueryResults.add(array[i][0]);
            }
            if (secondQuery != null) {
                String secondSql = secondQuery.toString();
                array = PersistenceManager.getPersistenceDelegate().executeQuery(secondSql, new Object[0]);
                for (int i = 0; i < array.length; ++i) {
                    if (firstQueryResults.contains(array[i][0]) || array[i][0] == null) continue;
                    results.add(array[i][0]);
                }
            }
        }
        return results;
    }
}

