/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceMetaData;
import java.util.Set;

class Or
implements QueryComponent {
    private QueryComponent leftSide;
    private QueryComponent rightSide;

    public Or(QueryComponent firstComponent) {
        this.leftSide = firstComponent;
    }

    public void setRightSide(QueryComponent newRightSide) {
        if (this.rightSide != null) {
            throw new IllegalStateException("Right side of or() operation already filled: \"" + this.rightSide + "\"");
        }
        this.rightSide = newRightSide;
    }

    @Override
    public void resolve(PersistenceMetaData resolveUsing) throws QueryException {
        if (this.rightSide == null) {
            throw new QueryException("Unfinished or() operation.  Need to add another expression.");
        }
        if (this.leftSide == null) {
            throw new QueryException("or() cannot be the first restriction in a query.  You need to have other operations on either side of the or().");
        }
        this.leftSide.resolve(resolveUsing);
        this.rightSide.resolve(resolveUsing);
    }

    public void addNeededTables(Set tableMap) {
        this.leftSide.addNeededTables(tableMap);
        this.rightSide.addNeededTables(tableMap);
    }

    @Override
    public String toString() {
        return this.leftSide.toString() + " OR " + this.rightSide.toString();
    }
}

