/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.PrefixTextSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyValueSearcher<P> {
    private Map<PropertiedObject.Property<P>, SingleValueQuerySearchFilter> propertyFilterMap;
    private ObjectQuery baseQuery = new ObjectQuery();
    private ObjectQuery query;

    public PropertyValueSearcher(PropertiedObject.Property<P> targetProperty, SingleValueQuerySearchFilter filter) {
        this.baseQuery.distinct();
        this.propertyFilterMap = new HashMap<PropertiedObject.Property<P>, SingleValueQuerySearchFilter>();
        this.addEquivalentProperty(targetProperty, filter);
    }

    public void addEquivalentProperty(PropertiedObject.Property<P> anotherProperty, SingleValueQuerySearchFilter filter) {
        this.propertyFilterMap.put(anotherProperty, filter);
        if (filter == null) {
            this.propertyFilterMap.put(anotherProperty, new PrefixTextSearchFilter(anotherProperty));
        }
        this.baseQuery.select(anotherProperty);
    }

    public ObjectQuery getObjectQuery() {
        return this.baseQuery;
    }

    public void updateSearchValue(P value) {
        this.query = new ObjectQuery(this.baseQuery);
        for (SingleValueQuerySearchFilter nextFilter : this.propertyFilterMap.values()) {
            nextFilter.setSearchValue(value);
            nextFilter.addQueryRestriction(this.query);
        }
    }

    public List<P> getMatches() {
        Object[][] array = PersistenceManager.getPersistenceDelegate().executeQuery(this.query.toString(), null);
        ArrayList<Object> results = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (array[i][j] == null) continue;
                results.add(array[i][j]);
            }
        }
        return results;
    }
}

