/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.AbstractPropertyQueryComponent;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;

class QueryRestriction
extends AbstractPropertyQueryComponent {
    private boolean useParam;
    protected boolean needEscape = true;
    private Object value;
    protected String operator;
    private String columnName;
    private String alias;
    private final String[] validOps = new String[]{"LIKE", "=", "<", ">", "!=", ">=", "<=", "BETWEEN"};
    private String sql;

    public QueryRestriction(PropertiedObject.Property newProperty, String op) {
        super(newProperty);
        this.isValidOp(op);
        this.operator = op;
        this.useParam = false;
    }

    public QueryRestriction(String columnName, Collection selectedObjs) {
        this((PropertiedObject.Property)null, selectedObjs);
        this.columnName = columnName;
    }

    public QueryRestriction(PropertiedObject.Property newProperty, String op, Object newValue) {
        this(newProperty, op, newValue, false);
    }

    public QueryRestriction(PropertiedObject.Property newProperty, String op, Object newValue, boolean literal) {
        super(newProperty);
        this.isValidOp(op);
        this.value = newValue;
        this.operator = op;
        this.useParam = true;
        this.needEscape = !literal;
    }

    protected String getColumnName() {
        return this.columnName;
    }

    public QueryRestriction(PropertiedObject.Property newProperty, Collection objects) {
        super(newProperty);
        this.operator = " IN ";
        this.useParam = true;
        this.needEscape = false;
        if (objects == null || objects.isEmpty()) {
            this.value = "( NULL )";
            return;
        }
        LinkedHashSet<Long> valueSet = new LinkedHashSet<Long>(objects.size());
        if (objects.iterator().next() instanceof PersistentObject) {
            for (PersistentObjectI object : objects) {
                if (object == null || object.getID() == null) continue;
                valueSet.add(object.getID());
            }
        } else {
            valueSet.addAll(objects);
            valueSet.remove(null);
        }
        String parenthesizedValues = "(";
        boolean first = true;
        Iterator it = valueSet.iterator();
        while (it.hasNext()) {
            Object currentValue;
            if (!first) {
                parenthesizedValues = parenthesizedValues + ",";
            } else {
                first = false;
            }
            if ((currentValue = it.next()) == null) continue;
            parenthesizedValues = parenthesizedValues + "'" + StringUtils.escapeStringForSQL(currentValue.toString(), true) + "'";
        }
        this.value = parenthesizedValues.equalsIgnoreCase("(") ? "( NULL )" : parenthesizedValues + ")";
    }

    @Override
    public void resolve(PersistenceMetaData persistence) {
        if (this.alias != null) {
            this.sql = this.alias;
        } else if (this.columnName == null) {
            super.resolve(persistence);
            this.sql = this.getTable() + "." + this.getColumn() + " ";
        } else {
            this.sql = this.columnName;
        }
        this.sql = this.addCondition(this.sql);
    }

    @Override
    public String toString() {
        return this.sql;
    }

    protected String addCondition(String startSQL) {
        Object localValue;
        String newSql = startSQL;
        newSql = !this.useParam ? newSql + this.operator + " ?" : ((localValue = this.translateValue(this.value)) != null ? newSql + this.operator + " " + this.escapeValue(localValue) : newSql + "IS NULL");
        return newSql;
    }

    protected Object translateValue(Object val) {
        Object localValue = val;
        if (localValue instanceof PersistentObjectI) {
            PersistentObjectI obj = (PersistentObjectI)localValue;
            localValue = obj.getID();
        } else {
            if (localValue instanceof Date && !(localValue instanceof Time) && !(localValue instanceof Timestamp) && !(localValue instanceof java.sql.Date)) {
                throw new IllegalStateException("Local value is a java.util.date, this is ambiguous when converting to sql date/time types\nUse one of java.sql.Date, Time or Timestamp");
            }
            if (localValue instanceof Price) {
                localValue = ((Price)localValue).toString(false);
            } else if (localValue instanceof Boolean) {
                return Boolean.TRUE.equals(localValue) ? Integer.valueOf(1) : Integer.valueOf(0);
            }
        }
        return localValue;
    }

    protected String escapeValue(Object toEscape) {
        if (toEscape == null) {
            return null;
        }
        String escapedValue = toEscape.toString();
        if (!(toEscape instanceof Number) && this.needEscape) {
            escapedValue = "'" + StringUtils.escapeStringForSQL(escapedValue, false) + "'";
        }
        return escapedValue;
    }

    protected boolean isValidOp(String op) {
        for (String validOp : this.validOps) {
            if (!op.equalsIgnoreCase(validOp)) continue;
            return true;
        }
        throw new IllegalArgumentException("Operator: (" + op + ") is not valid query restriction operator");
    }

    protected Object getValue() {
        return this.value;
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    public String getAlias() {
        return this.alias;
    }
}

