/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery;

import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.QueryException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Set;

class SumMultiplication
implements QueryComponent {
    private PropertiedObject.Property property1;
    private PropertiedObject.Property property2;
    private String col1;
    private String col2;
    private String table1;
    private String table2;
    private String name;
    private boolean nullSafe;

    public SumMultiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2) {
        this(prop1, prop2, null);
    }

    public SumMultiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2, String newName) {
        this.property1 = prop1;
        this.property2 = prop2;
        this.name = newName;
        this.nullSafe = false;
    }

    public SumMultiplication(PropertiedObject.Property prop1, PropertiedObject.Property prop2, String newName, boolean nSafe) {
        this.property1 = prop1;
        this.property2 = prop2;
        this.name = newName;
        this.nullSafe = nSafe;
    }

    @Override
    public void resolve(PersistenceMetaData persistence) throws QueryException {
        if (!PersistenceManager.getInstance().classSupportsQueries(this.property1.getOwner())) {
            throw new QueryException("Problem with query component.  Class " + this.property1.getOwner() + " does not support queries");
        }
        this.table1 = persistence.getClassTable(this.property1.getOwner());
        this.col1 = persistence.getPropertyColumn(this.property1);
        if (!PersistenceManager.getInstance().classSupportsQueries(this.property2.getOwner())) {
            throw new QueryException("Problem with query component.  Class " + this.property2.getOwner() + " does not support queries");
        }
        this.table2 = persistence.getClassTable(this.property2.getOwner());
        this.col2 = persistence.getPropertyColumn(this.property2);
    }

    public void addNeededTables(Set tableMap) {
        tableMap.add(this.table1);
        tableMap.add(this.table2);
    }

    @Override
    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        String sql = !this.nullSafe ? strBuilder.append("SUM(").append(this.table1).append(".").append(this.col1).append(" * ").append(this.table2).append(".").append(this.col2).append(") as ").toString() : strBuilder.append("SUM(IFNULL(").append(this.table1).append(".").append(this.col1).append(" * ").append(this.table2).append(".").append(this.col2).append(",0)) as ").toString();
        sql = this.name == null ? sql + "Sum_" + this.col1.toLowerCase() + "_by_" + this.col2.toLowerCase() : sql + this.name;
        return sql;
    }
}

