/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.QueryModifier;
import au.com.ordermate.oquery.search.filter.AbstractSearcher;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.search.SearchFilterI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.OrderMate;

public abstract class PropertySearcher<T extends PersistentObjectI>
extends AbstractSearcher<T> {
    private int limit;
    private int offset = 0;
    private List<QueryModifier> mods;

    protected abstract ObjectQuery getBaseQuery();

    public void setQueryMods(List<QueryModifier> yoursMods) {
        this.mods = yoursMods;
    }

    public PropertySearcher(Class<T> persistentObjClass) {
        super(persistentObjClass);
    }

    public PropertySearcher(Class<T> persistentObjClass, Collection<? extends SearchFilterI> newSearchFilters) {
        super(persistentObjClass, newSearchFilters);
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery query = this.getBaseQuery();
        query = this.addSearchFilterRestrictions(query);
        if (OrderMate.LOG.isDebugEnabled()) {
            OrderMate.LOG.debug(this.getClass().getSimpleName() + " query: " + query.copy());
        }
        if (this.limit > 0) {
            query.limit(this.limit, this.offset);
        }
        if (this.mods != null) {
            for (QueryModifier modifier : this.mods) {
                query = modifier.modifyQuery(query);
            }
        }
        return query;
    }

    protected List<QuerySearchFilter> getQuerySearchFilters() {
        ArrayList<QuerySearchFilter> queryFilters = new ArrayList<QuerySearchFilter>();
        for (SearchFilterI filter : this.getSearchFilters()) {
            if (!(filter instanceof QuerySearchFilter)) continue;
            queryFilters.add((QuerySearchFilter)filter);
        }
        return queryFilters;
    }

    protected final ObjectQuery addSearchFilterRestrictions(ObjectQuery query) {
        ObjectQuery localQuery = query;
        for (QuerySearchFilter prop : this.getQuerySearchFilters()) {
            localQuery = prop.addQueryRestriction(localQuery);
        }
        return localQuery;
    }

    public final void resetOffset() {
        this.offset = 0;
    }

    public final ObjectQuery next() {
        if (this.limit == 0) {
            throw new IllegalStateException("Limit is zero, cannot call next");
        }
        ObjectQuery query = this.getObjectQuery().limit(this.limit, this.offset);
        this.offset += this.limit;
        return query;
    }

    public final void setLimit(int resultLimit) {
        this.limit = resultLimit;
    }
}

