/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control;

import au.com.ordermate.oquery.search.control.SearchValueTranslator;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.CustomerPolyEmptyPropertySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.CustomerTenureSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FrequentCustomerSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FullTextJointSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import java.util.Date;
import java.util.List;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;
import ordermate.security.impl.DateUtils;

public class SearchFilterControl<T> {
    private final SearchValueTranslator translator;
    private boolean allowNull = true;
    private final String name;
    private boolean priority = true;
    private int sequence = 100;
    private String makerName = "";
    private String filterLink = "";
    private String defaultValue = "";

    public SearchFilterControl(String name, SearchValueTranslator yourTranslator) {
        this.name = name;
        this.translator = yourTranslator;
    }

    public SearchFilterControl<T> setAllowNull(boolean value) {
        this.allowNull = value;
        return this;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public String getName() {
        return this.name;
    }

    public void parseAndSetValue(String string, SearchFilterI filter) {
        Object value = this.translator.toSearchValue(string);
        if (value == null) {
            if (this.allowNull) {
                filter.clearSearch();
                return;
            }
            throw new IllegalStateException(this.name + " must not be empty");
        }
        if (filter instanceof TimeSearchFilter && value instanceof List) {
            if (((List)value).get(0) instanceof Date) {
                ((List)value).set(0, DateUtils.convertDateToCalendar((Date)((List)value).get(0)));
            }
            if (((List)value).get(1) instanceof Date) {
                ((List)value).set(1, DateUtils.convertDateToCalendar((Date)((List)value).get(1)));
            }
        }
        if (filter instanceof ISingleValueSearchFilter) {
            if (filter instanceof CustomerPolyEmptyPropertySearchFilter) {
                ((CustomerPolyEmptyPropertySearchFilter)filter).setSearchValue(value.toString());
            } else if (filter instanceof CustomerTenureSearchFilter) {
                ((CustomerTenureSearchFilter)filter).setSearchValue(value.toString());
            } else {
                ((ISingleValueSearchFilter)filter).setSearchValue(value);
            }
        } else if (filter instanceof IRangedQuerySearchFilter) {
            if (value instanceof List) {
                Comparable start = (Comparable)((List)value).get(0);
                Comparable end = (Comparable)((List)value).get(1);
                if (start == null || end == null) {
                    throw new IllegalStateException(this.name + " must have a start and an end");
                }
                ((IRangedQuerySearchFilter)filter).setStart(start);
                ((IRangedQuerySearchFilter)filter).setEnd(end);
            }
            if (filter instanceof FrequentCustomerSearchFilter) {
                ((FrequentCustomerSearchFilter)filter).setSearchValue(value.toString());
            }
        } else if (filter instanceof FullTextJointSearchFilter) {
            ((FullTextJointSearchFilter)filter).setString(value.toString());
        }
    }

    public Object getTranslatedValue(String string) {
        return this.translator.toSearchValue(string);
    }

    public SearchValueTranslator getTranslator() {
        return this.translator;
    }

    public List<SMReportFilterOptions> getOptions() {
        return this.translator.getOptions();
    }

    public boolean isPriority() {
        return this.priority;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public String getMakerName() {
        return this.makerName;
    }

    public void setMakerName(String makerName) {
        this.makerName = makerName;
    }

    public String getFilterLink() {
        return this.filterLink;
    }

    public void setFilterLink(String filterLink) {
        this.filterLink = filterLink;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

