/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.control.SearchFilterControl;
import au.com.ordermate.oquery.search.control.SearchValueTranslator;
import au.com.ordermate.oquery.search.control.translator.AbstractSearchValueTranslator;
import au.com.ordermate.oquery.search.control.translator.BooleanTranslator;
import au.com.ordermate.oquery.search.control.translator.DateTranslator;
import au.com.ordermate.oquery.search.control.translator.EnumTranslator;
import au.com.ordermate.oquery.search.control.translator.IntegerTranslator;
import au.com.ordermate.oquery.search.control.translator.MultipleTranslator;
import au.com.ordermate.oquery.search.control.translator.PersistentEnumTranslator;
import au.com.ordermate.oquery.search.control.translator.RangeTranslator;
import au.com.ordermate.oquery.search.control.translator.ReferenceTranslator;
import au.com.ordermate.oquery.search.control.translator.StringTranslator;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.search.SearchFilterI;
import java.util.Date;

public class SearchFilterControlFactory {
    public SearchFilterControl createFilterControl(FilterConfig config) {
        FilterConfig.Plural plural = config.plural();
        Class clazz = config.dataType();
        SQLDateType dateType = config.dateType();
        String name = config.name();
        boolean nullAllowed = config.nullAllowed();
        boolean showable = config.priority();
        int sequence = config.sequence();
        String makerName = config.makerName();
        String filterLink = config.filterLink();
        String defaultValue = config.defaultValue();
        return this.resolveSearchControl(name, plural, clazz, nullAllowed, dateType, config.where(), config.select(), config.order(), showable, sequence, makerName, filterLink, defaultValue);
    }

    protected SearchFilterControl createFilterControl(SearchFilterI filter, String methodName) {
        FilterConfig.Plural plural = this.resolvePlural(filter);
        Class<String> clazz = String.class;
        SQLDateType dateType = SQLDateType.TIMESTAMP;
        String name = methodName.substring(4);
        boolean nullAllowed = true;
        return this.resolveSearchControl(name, plural, clazz, nullAllowed, dateType, null, null, null, true, 100, "", "", "");
    }

    private SearchFilterControl resolveSearchControl(String name, FilterConfig.Plural plural, Class clazz, boolean nullAllowed, SQLDateType dateType, String where, String select, String order, boolean priority, int sequence, String makerName, String filterLink, String defaultValue) {
        SearchValueTranslator translator = this.findTranslator(plural, clazz, dateType, where, select, order);
        SearchFilterControl control = new SearchFilterControl(name, translator);
        control.setAllowNull(nullAllowed);
        control.setPriority(priority);
        control.setSequence(sequence);
        control.setMakerName(makerName);
        control.setFilterLink(filterLink);
        control.setDefaultValue(defaultValue);
        return control;
    }

    private SearchValueTranslator findTranslator(FilterConfig.Plural plural, Class clazz, SQLDateType dateType, String where, String select, String order) {
        SearchValueTranslator translator = this.getTranslatorForClass(clazz, dateType);
        if (translator instanceof ReferenceTranslator) {
            ((ReferenceTranslator)translator).setQueryParts(where, order);
        }
        if (translator instanceof StringTranslator) {
            ((StringTranslator)translator).setQuery(select);
        }
        if (FilterConfig.Plural.Ranged.equals((Object)plural)) {
            translator = new RangeTranslator(translator);
        } else if (FilterConfig.Plural.Multiple.equals((Object)plural)) {
            translator = new MultipleTranslator(translator);
        }
        return translator;
    }

    private SearchValueTranslator getTranslatorForClass(Class clazz, SQLDateType dateType) {
        AbstractSearchValueTranslator translator = Date.class.equals((Object)clazz) ? new DateTranslator(dateType) : (String.class.equals((Object)clazz) ? new StringTranslator() : (PersistentObject.class.isAssignableFrom(clazz) ? new ReferenceTranslator(clazz) : (PersistentEnumeration.class.isAssignableFrom(clazz) ? new PersistentEnumTranslator(clazz) : (Enum.class.isAssignableFrom(clazz) ? new EnumTranslator(clazz) : (clazz.isAssignableFrom(Boolean.class) ? new BooleanTranslator() : (clazz.isAssignableFrom(Integer.class) ? new IntegerTranslator() : new StringTranslator()))))));
        return translator;
    }

    private FilterConfig.Plural resolvePlural(SearchFilterI filter) {
        if (filter instanceof IRangedQuerySearchFilter) {
            return FilterConfig.Plural.Ranged;
        }
        if (filter instanceof MultiOptionSearchFilter) {
            return FilterConfig.Plural.Multiple;
        }
        return FilterConfig.Plural.Single;
    }
}

