/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control.translator;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.date.DateOperatorFactory;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.control.translator.AbstractSearchValueTranslator;
import au.com.ordermate.util.StringUtils;

public class DateTranslator
extends AbstractSearchValueTranslator {
    private final SQLDateType type;

    public DateTranslator(SQLDateType type) {
        this.type = type == null ? SQLDateType.DATE : type;
    }

    @Override
    protected Object translateNonNullString(String string) {
        Operator operator = new DateOperatorFactory().createOperator(string);
        if (operator != null) {
            return operator.getValue();
        }
        return null;
    }

    @Override
    protected String translateNonNullValue(Object value) {
        return (String)value;
    }

    @Override
    protected Object getDefaultValue() {
        return null;
    }

    @Override
    public String getFormat() {
        return StringUtils.firstCharToUpperCase(this.type.name().toLowerCase());
    }
}

