/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control.translator;

import au.com.ordermate.oquery.search.control.translator.AbstractSearchValueTranslator;
import java.util.ArrayList;
import java.util.List;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;

public class EnumTranslator
extends AbstractSearchValueTranslator {
    private final Class<? extends Enum> enumType;

    public EnumTranslator(Class<? extends Enum> yourEnum) {
        this.enumType = yourEnum;
    }

    @Override
    protected Object translateNonNullString(String string) {
        return Enum.valueOf(this.enumType, string);
    }

    @Override
    protected String translateNonNullValue(Object value) {
        return ((Enum)value).name();
    }

    @Override
    protected Object getDefaultValue() {
        return null;
    }

    @Override
    public String getFormat() {
        return "Enum";
    }

    @Override
    public List<SMReportFilterOptions> getOptions() {
        ArrayList<SMReportFilterOptions> options = new ArrayList<SMReportFilterOptions>();
        for (Enum next : this.enumType.getEnumConstants()) {
            SMReportFilterOptions option = new SMReportFilterOptions();
            option.setId(next.name());
            option.setLabel(next.toString());
            options.add(option);
        }
        return options;
    }
}

