/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control.translator;

import au.com.ordermate.oquery.search.control.SearchValueTranslator;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;

public class MultipleTranslator
implements SearchValueTranslator {
    private SearchValueTranslator translator;
    private static final String SEPARATOR = ":";

    public MultipleTranslator(SearchValueTranslator subTranslator) {
        this.translator = subTranslator;
    }

    @Override
    public String toDBString(Object value) {
        if (value != null) {
            StringBuilder SB = new StringBuilder();
            List values = (List)value;
            for (Object nextValue : values) {
                SB.append(this.translator.toDBString(nextValue));
                SB.append(SEPARATOR);
            }
            if (SB.length() > 0) {
                return SB.toString();
            }
        }
        return null;
    }

    @Override
    public Object toSearchValue(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        List<String> splits = StringUtils.splitToList(string, SEPARATOR);
        ArrayList<Object> toReturn = new ArrayList<Object>();
        for (String value : splits) {
            Object resolved = this.translator.toSearchValue(value);
            if (resolved == null) continue;
            toReturn.add(resolved);
        }
        return toReturn.size() > 0 ? toReturn : null;
    }

    public SearchValueTranslator getSubTranslator() {
        return this.translator;
    }

    @Override
    public String getFormat() {
        return this.translator.getFormat() + SEPARATOR + "n";
    }

    @Override
    public List<SMReportFilterOptions> getOptions() {
        return this.translator.getOptions();
    }
}

