/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control.translator;

import au.com.ordermate.oquery.search.control.translator.AbstractSearchValueTranslator;
import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;

public class PersistentEnumTranslator
extends AbstractSearchValueTranslator {
    private final Class<? extends PersistentEnumeration> pEnumType;
    private Map<String, PersistentEnumeration> register;

    public PersistentEnumTranslator(Class<? extends PersistentEnumeration> yourEnum) {
        this.pEnumType = yourEnum;
        try {
            Map theirReg = (Map)this.pEnumType.getField("register").get(null);
            this.register = new HashMap<String, PersistentEnumeration>();
            for (PersistentEnumeration nextEnum : theirReg.values()) {
                this.register.put(nextEnum.getLabel(), nextEnum);
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Cannot get the persistent enumeration register for " + this.pEnumType);
        }
    }

    @Override
    public String getFormat() {
        return "Enum";
    }

    @Override
    protected Object translateNonNullString(String string) {
        return this.register.get(string);
    }

    @Override
    protected String translateNonNullValue(Object value) {
        return ((PersistentEnumeration)value).getLabel();
    }

    @Override
    protected Object getDefaultValue() {
        return null;
    }

    @Override
    public List<SMReportFilterOptions> getOptions() {
        ArrayList<SMReportFilterOptions> options = new ArrayList<SMReportFilterOptions>();
        for (String next : this.register.keySet()) {
            SMReportFilterOptions option = new SMReportFilterOptions();
            option.setLabel(next);
            options.add(option);
        }
        return options;
    }
}

