/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control.translator;

import au.com.ordermate.oquery.search.control.SearchValueTranslator;
import java.util.ArrayList;
import java.util.List;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;

public class RangeTranslator
implements SearchValueTranslator {
    private SearchValueTranslator translator;
    private final String SEPARATOR = ":";

    public RangeTranslator(SearchValueTranslator yourTranslator) {
        this.translator = yourTranslator;
    }

    @Override
    public String toDBString(Object value) {
        if (value != null) {
            StringBuilder SB = new StringBuilder();
            List values = (List)value;
            if (!values.isEmpty()) {
                SB.append(this.translator.toDBString(values.get(0))).append(":").append(this.translator.toDBString(values.get(1)));
                return SB.toString();
            }
        }
        return null;
    }

    @Override
    public Object toSearchValue(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String[] splits = string.split(":");
        if (splits.length == 2) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(this.translator.toSearchValue(splits[0]));
            values.add(this.translator.toSearchValue(splits[1]));
            return values;
        }
        if (splits.length == 1) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(this.translator.toSearchValue(splits[0]));
            values.add(this.translator.toSearchValue(splits[0]));
            return values;
        }
        return null;
    }

    public SearchValueTranslator getSubTranslator() {
        return this.translator;
    }

    @Override
    public String getFormat() {
        return this.translator.getFormat() + ":" + this.translator.getFormat();
    }

    @Override
    public List<SMReportFilterOptions> getOptions() {
        return this.translator.getOptions();
    }
}

