/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control.translator;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.StringQueryComponent;
import au.com.ordermate.oquery.search.control.translator.AbstractSearchValueTranslator;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;

public class ReferenceTranslator
extends AbstractSearchValueTranslator {
    private final Class<? extends PersistentObject> objectClazz;
    private String where = null;
    private String order = null;

    public ReferenceTranslator(Class<? extends PersistentObject> yourClazz) {
        this.objectClazz = yourClazz;
    }

    public void setQueryParts(String where, String order) {
        this.where = StringUtils.isEmpty(where) ? null : where;
        this.order = StringUtils.isEmpty(order) ? null : order;
    }

    @Override
    protected Object translateNonNullString(String string) {
        try {
            long id = Long.parseLong(string);
            PersistentObject resolvedValue = PersistenceManager.getByID(id, this.objectClazz);
            return resolvedValue;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot get reference search criteria " + string, (Throwable)ex);
            return null;
        }
    }

    @Override
    protected String translateNonNullValue(Object value) {
        return String.valueOf(((PersistentObject)value).getID());
    }

    @Override
    protected Object getDefaultValue() {
        return null;
    }

    @Override
    public String getFormat() {
        return "Ref";
    }

    @Override
    public List<SMReportFilterOptions> getOptions() {
        try {
            if (PersistentObject.class.isAssignableFrom(this.objectClazz) && PersistenceManager.getInstance().classSupportsQueries(this.objectClazz)) {
                ArrayList<SMReportFilterOptions> options = new ArrayList<SMReportFilterOptions>();
                ObjectQuery query = Query.select(this.objectClazz);
                PersistentObject.Props props = (PersistentObject.Props)this.objectClazz.getField("Properties").get(null);
                boolean hasSystemState = props.hasProperty("systemState");
                if (hasSystemState) {
                    query.active(this.objectClazz);
                }
                if (this.where != null) {
                    query.whereFunction(this.where);
                }
                if (this.order != null) {
                    query.orderBy(new StringQueryComponent(this.order));
                }
                List<? extends PersistentObject> objects = PersistenceManager.getObjectList(this.objectClazz, query.toString());
                for (PersistentObject persistentObject : objects) {
                    SMReportFilterOptions option = new SMReportFilterOptions();
                    option.setId(persistentObject.getID().toString());
                    option.setLabel(persistentObject.toString());
                    options.add(option);
                }
                return options;
            }
        }
        catch (ClassCastException e) {
            OrderMate.LOG.error("Couldn't cast the value passed!", (Throwable)e);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error resolving properties for a reference object!", (Throwable)ex);
        }
        return null;
    }
}

