/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.control.translator;

import au.com.ordermate.oquery.search.control.translator.AbstractSearchValueTranslator;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;

public class StringTranslator
extends AbstractSearchValueTranslator {
    private String select = null;

    @Override
    protected Object translateNonNullString(String string) {
        return string;
    }

    public void setQuery(String select) {
        this.select = StringUtils.isEmpty(select) ? null : select;
    }

    @Override
    protected String translateNonNullValue(Object value) {
        return String.valueOf(value);
    }

    @Override
    protected Object getDefaultValue() {
        return null;
    }

    @Override
    public String getFormat() {
        return "String";
    }

    @Override
    public List<SMReportFilterOptions> getOptions() {
        try {
            if (StringUtils.isEmpty(this.select)) {
                return null;
            }
            ArrayList<SMReportFilterOptions> options = new ArrayList<SMReportFilterOptions>();
            Object[][] rs = PersistenceManager.getPersistenceDelegate().executeQuery(this.select, null);
            for (int i = 0; i < rs.length; ++i) {
                Object[] objs = rs[i];
                StringBuilder rowSB = new StringBuilder();
                for (int j = 0; j < objs.length; ++j) {
                    Object obj = rs[i][j];
                    if (j != 0) {
                        rowSB.append(",");
                    }
                    if (obj == null) continue;
                    rowSB.append(obj);
                }
                if (rowSB.toString().isEmpty()) continue;
                SMReportFilterOptions option = new SMReportFilterOptions();
                option.setId(rowSB.toString());
                option.setLabel(rowSB.toString());
                options.add(option);
            }
            return options;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error resolving properties for a reference object!", (Throwable)ex);
            return null;
        }
    }
}

