/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.search.SearchFilterI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class AbstractSearcher<T extends PersistentObjectI>
implements ObjectQuerySearcher<T> {
    private final Class<T> persistentObjectClass;
    private final Collection<SearchFilterI> searchFilters = new LinkedHashSet<SearchFilterI>();
    private boolean active = true;

    public AbstractSearcher(Class<T> searchClass) {
        this(searchClass, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSearcher(Class<T> searchClass, Collection<? extends SearchFilterI> addSearchFilters) {
        if (searchClass == null) {
            throw new IllegalArgumentException("Class to search for should not be NULL");
        }
        this.persistentObjectClass = searchClass;
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            this.searchFilters.addAll(addSearchFilters);
        }
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public List<T> search() {
        if (this.active) {
            return PersistenceManager.getObjectList(this);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSearchFilters(Collection<? extends SearchFilterI> newSearchFilters) {
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            this.searchFilters.clear();
            this.searchFilters.addAll(newSearchFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchFilter(SearchFilterI searchProp) {
        if (searchProp == null) {
            throw new IllegalArgumentException("Not allowed to add a null search filter");
        }
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            if (!this.searchFilters.contains(searchProp)) {
                this.searchFilters.add(searchProp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSearchFilter(SearchFilterI searchProp) {
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            this.searchFilters.remove(searchProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSearchFilterValues() {
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            for (SearchFilterI prop : this.searchFilters) {
                prop.clearSearch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSearchValues() {
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            for (SearchFilterI filter : this.searchFilters) {
                if (!filter.hasSearchValue()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchFilterI> getSearchFilters() {
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            return new ArrayList<SearchFilterI>(this.searchFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<SearchFilterI> getUnmodifiableFilters() {
        Collection<SearchFilterI> collection = this.searchFilters;
        synchronized (collection) {
            return new ArrayList<SearchFilterI>(this.searchFilters);
        }
    }

    @Override
    public final Class<T> getPersistentClass() {
        return this.persistentObjectClass;
    }
}

