/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.abstracts;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;

public abstract class AbstractPolyPropertySearchFilter<T>
implements ISingleValueSearchFilter<T>,
QuerySearchFilter {
    private PropertiedObject.Property[] properties;
    private Condition condStatement;

    public AbstractPolyPropertySearchFilter(PropertiedObject.Property[] props) {
        if (props == null) {
            throw new IllegalArgumentException("Property[] paramenter cannot equal null");
        }
        this.properties = props;
        this.condStatement = Condition.AND;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (this.hasSearchValue()) {
            query.group();
            for (int i = 0; i < this.properties.length; ++i) {
                query.group();
                this.appendRepeatedQuery(query, this.properties[i]);
                query.endGroup();
                if (this.condStatement != Condition.OR || i == this.properties.length - 1) continue;
                query.or();
            }
            query.endGroup();
        }
        return query;
    }

    public PropertiedObject.Property[] getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiedObject.Property[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Property[] paramenter cannot equal null");
        }
        this.properties = value;
    }

    public Condition getCondition() {
        return this.condStatement;
    }

    public void setCondition(Condition value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot set condition to null");
        }
        this.condStatement = value;
    }

    @Override
    public PropertiedObject.Property getProperty() {
        return null;
    }

    @Override
    public void setProperty(PropertiedObject.Property prop) {
    }

    protected abstract ObjectQuery appendRepeatedQuery(ObjectQuery var1, PropertiedObject.Property var2);

    public static enum Condition {
        AND,
        OR;

    }
}

