/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.Date;

public class ComparisonSearchFilter<T>
extends SingleValueSearchFilter<T>
implements QuerySearchFilter {
    private final String op;
    private SQLDateType dateType;

    public static <T> ComparisonSearchFilter<T> createGreaterThan(PropertiedObject.Property prop) {
        return new ComparisonSearchFilter<T>(prop, ">");
    }

    public static <T> ComparisonSearchFilter<T> createLessThan(PropertiedObject.Property prop) {
        return new ComparisonSearchFilter<T>(prop, "<");
    }

    public static <T> ComparisonSearchFilter<T> createGreaterThanEqualTo(PropertiedObject.Property prop) {
        return new ComparisonSearchFilter<T>(prop, ">=");
    }

    public static <T> ComparisonSearchFilter<T> createLessThanEqualsTo(PropertiedObject.Property prop) {
        return new ComparisonSearchFilter<T>(prop, "<=");
    }

    protected ComparisonSearchFilter(PropertiedObject.Property prop, String op) {
        super(prop);
        this.op = op;
        if (!(op.equals("<") || op.equals(">") || op.equals("<=") || op.equals(">="))) {
            throw new IllegalArgumentException("Unknown op : " + op);
        }
    }

    public ComparisonSearchFilter<Date> usingDateType(SQLDateType type) {
        this.dateType = type;
        return this;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        if (this.dateType == null) {
            if (this.op.equals(">")) {
                query.greaterThan(this.getProperty(), this.getSearchValue());
            } else if (this.op.equals("<")) {
                query.lessThan(this.getProperty(), this.getSearchValue());
            } else if (this.op.equals(">=")) {
                query.greaterThanOrEqual(this.getProperty(), this.getSearchValue());
            } else if (this.op.equals("<=")) {
                query.lessThanOrEqual(this.getProperty(), this.getSearchValue());
            }
        } else if (this.op.equals(">")) {
            query.greaterThan(this.getProperty(), (Date)this.getSearchValue(), this.dateType);
        } else if (this.op.equals("<")) {
            query.lessThan(this.getProperty(), (Date)this.getSearchValue(), this.dateType);
        } else if (this.op.equals(">=")) {
            query.greaterThanOrEqual(this.getProperty(), (Date)this.getSearchValue(), this.dateType);
        } else if (this.op.equals("<=")) {
            query.lessThanOrEqual(this.getProperty(), (Date)this.getSearchValue(), this.dateType);
        }
        return query;
    }
}

