/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.sales.Customer;

public class CustomerTenureSearchFilter
extends ObjectSearchFilter<Date> {
    private UnitOfTime rangeType = UnitOfTime.DAY;
    private long tenureAsLong;
    private Date minimumTenure = new Date();
    private int rangeValue = 0;

    public CustomerTenureSearchFilter(PropertiedObject.Property prop) {
        super(prop);
    }

    @Override
    public void setSearchValue(String value) {
        if (value == null || value.equals("")) {
            return;
        }
        String[] valueList = value.split(":");
        this.setRangeValue(Integer.parseInt(valueList[0]));
        if (valueList[1].equalsIgnoreCase(UnitOfTime.DAY.toString())) {
            this.setRangeType(UnitOfTime.DAY);
        } else if (valueList[1].equalsIgnoreCase(UnitOfTime.WEEK.toString())) {
            this.setRangeType(UnitOfTime.WEEK);
        } else if (valueList[1].equalsIgnoreCase(UnitOfTime.MONTH.toString())) {
            this.setRangeType(UnitOfTime.MONTH);
        } else if (valueList[1].equalsIgnoreCase(UnitOfTime.YEAR.toString())) {
            this.setRangeType(UnitOfTime.YEAR);
        }
    }

    @Override
    public boolean hasSearchValue() {
        return this.rangeValue > 0;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        ObjectQuery superQuery = query;
        if (this.hasSearchValue()) {
            this.minimumTenure = this.calculateMinimumTenure(this.rangeValue);
            superQuery.lessThan(Customer.Properties.CREATION_TIME, this.minimumTenure, SQLDateType.TIMESTAMP);
        }
        return superQuery;
    }

    private Date calculateMinimumTenure(int spinnerValue) {
        int dayCount = this.convertUnitOfTimeToTotalDays(spinnerValue);
        long daysinMS = this.convertTotalDaysToMillis(dayCount);
        Date minTenureDate = new Date(this.calculateDifference(daysinMS));
        return minTenureDate;
    }

    private int convertUnitOfTimeToTotalDays(int unitNum) {
        int value = 0;
        if (this.rangeType == UnitOfTime.DAY) {
            value = unitNum;
            return value;
        }
        if (this.rangeType == UnitOfTime.WEEK) {
            value = unitNum * 7;
        } else if (this.rangeType == UnitOfTime.MONTH) {
            value = unitNum * 30;
        } else if (this.rangeType == UnitOfTime.YEAR) {
            value = unitNum * 365;
        }
        return value;
    }

    private long convertTotalDaysToMillis(int days) {
        return (long)days * 86400000L;
    }

    private long calculateDifference(long timeLengthAsLong) {
        Date today = new Date();
        long todayAsLong = today.getTime();
        long difference = todayAsLong - timeLengthAsLong;
        return difference;
    }

    @Override
    public void clearSearch() {
        super.clearSearch();
        this.rangeValue = 0;
        this.minimumTenure = null;
    }

    public void setRangeValue(int newValue) {
        this.rangeValue = newValue;
    }

    public int getRangeValue() {
        return this.rangeValue;
    }

    public Date getMinimumTenure() {
        return this.minimumTenure;
    }

    public void setMinimumTenure(int newTenure) {
        this.minimumTenure = this.calculateMinimumTenure(newTenure);
    }

    public void setRangeType(UnitOfTime value) {
        if (value != null) {
            this.rangeType = value;
        }
    }

    public UnitOfTime getRangeType() {
        return this.rangeType;
    }

    public static enum UnitOfTime {
        DAY(5),
        WEEK(3),
        MONTH(2),
        YEAR(1);

        private final int calendarField;

        private UnitOfTime(int aCalendarField) {
            this.calendarField = aCalendarField;
        }

        public int getCalendarField() {
            return this.calendarField;
        }
    }
}

