/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;

public class DateRangeSearchFilter
extends RangeQuerySearchFilter<Date> {
    private final SQLDateType dateType;

    public DateRangeSearchFilter(PropertiedObject.Property prop, SQLDateType sqlDateType) {
        super(prop);
        this.dateType = sqlDateType;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        Date end;
        if (!this.hasSearchValue()) {
            return query;
        }
        Date start = (Date)this.getStart();
        if (start.compareTo(end = (Date)this.getEnd()) > 0) {
            start = (Date)this.getEnd();
            end = (Date)this.getStart();
        }
        return query.wherePropertyBetween(this.getProperty(), start, end, this.dateType);
    }

    public SQLDateType getDateType() {
        return this.dateType;
    }
}

