/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import java.util.Date;
import ordermate.database.finance.debtors.AbstractDebtor;

public class DebtorStatusSearchFilter
extends ObjectSearchFilter<String> {
    public DebtorStatusSearchFilter() {
        super(null);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        String value = (String)this.getSearchValue();
        ObjectQuery queryToReturn = query;
        if (value != null && !value.equals("Any")) {
            if (value.equalsIgnoreCase("PAID")) {
                queryToReturn = query.lessThan(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.005);
            } else if (value.equalsIgnoreCase("OUTSTANDING")) {
                queryToReturn = query.greaterThan(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.005);
            } else if (value.equalsIgnoreCase("OVERDUE")) {
                Date javaDate = new Date();
                queryToReturn = query.greaterThan(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.005).lessThan(AbstractDebtor.Properties.EARLIEST_DUE_DATE, new java.sql.Date(javaDate.getYear(), javaDate.getMonth(), javaDate.getDate()), SQLDateType.DATE);
            }
            return queryToReturn;
        }
        return queryToReturn;
    }
}

