/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.abstracts.AbstractMultiplePropertySearchFilter;
import org.apache.commons.collections.iterators.ArrayIterator;

public class EquivalentObjectSearchFilter
extends AbstractMultiplePropertySearchFilter
implements QuerySearchFilter {
    private SingleValueQuerySearchFilter searchProperty;

    public EquivalentObjectSearchFilter(PropertiedObject.Property[] equivProps, SingleValueQuerySearchFilter property) {
        super(equivProps);
        this.searchProperty = property;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (this.getPropertyJoinPath().length == 0) {
            return query;
        }
        if (!this.hasSearchValue()) {
            return query;
        }
        query.group();
        ArrayIterator it = new ArrayIterator((Object)this.getPropertyJoinPath());
        while (it.hasNext()) {
            PropertiedObject.Property currentProp = (PropertiedObject.Property)it.next();
            this.searchProperty.setProperty(currentProp);
            this.searchProperty.addQueryRestriction(query);
            if (!it.hasNext()) continue;
            query.or();
        }
        query.endGroup();
        return query;
    }

    public void setObject(Object value) {
        this.searchProperty.setSearchValue(value);
    }

    @Override
    public void clearSearch() {
        this.searchProperty.clearSearch();
    }

    @Override
    public boolean hasSearchValue() {
        return this.searchProperty.hasSearchValue();
    }

    public String toString() {
        return "EquivalentFilter[" + this.getProperty() + "]";
    }
}

