/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.abstracts.SingleValueSearchAdapter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.OffsetFunction;

public class FixedRangeSearchFilter<T extends Comparable<T>>
extends SingleValueSearchAdapter<T>
implements ISingleValueSearchFilter<T> {
    private OffsetFunction offsetter;

    public FixedRangeSearchFilter(IRangedQuerySearchFilter<T> search, OffsetFunction function) {
        super(search);
        this.offsetter = function;
    }

    public void setOffsetFunction(OffsetFunction<T> function) {
        if (this.offsetter != function) {
            this.offsetter = function;
            this.clearSearch();
        }
    }

    @Override
    public T getSearchValue() {
        return this.getRangedSearchProperty().getStart();
    }

    @Override
    public void setSearchValue(T value) {
        Object end;
        Object start = value;
        Object t = end = value != null ? (Object)this.offsetter.calcOffset(value) : null;
        if (start != null && start.compareTo(end) > 0) {
            this.getRangedSearchProperty().setStart(end);
            this.getRangedSearchProperty().setEnd(start);
        } else {
            this.getRangedSearchProperty().setStart(start);
            this.getRangedSearchProperty().setEnd(end);
        }
    }
}

