/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class FrequentCustomerSearchFilter
extends RangeQuerySearchFilter<Date> {
    private Date givenStartDate;
    private Date givenEndDate;
    private FrequentCustomerSearchType searchType = FrequentCustomerSearchType.Frequent;
    private UnitOfTime rangeType = UnitOfTime.WEEK;
    private int unitOfTimeCount;
    private int maxUnitOfTime;
    private boolean oneYear = true;
    private static final String MAX_VAR = "HIGHEST_UNIT_OF_TIME";
    private static final String COUNT_VAR = "UNIT_OF_TIME_COUNT";
    private static final int MIN_COUNT = 2;
    private static final int MAX_COUNT = 10;

    public FrequentCustomerSearchFilter(PropertiedObject.Property prop) {
        super(prop);
    }

    public FrequentCustomerSearchFilter(PropertiedObject.Property prop, SQLDateType type) {
        super(prop, type);
    }

    @Override
    public IRangedQuerySearchFilter<Date> setStart(Date newStartPoint) {
        this.givenStartDate = newStartPoint;
        IRangedQuerySearchFilter toReturn = (IRangedQuerySearchFilter)super.setStart(this.clampDate(this.givenStartDate).getTime());
        return toReturn;
    }

    @Override
    public IRangedQuerySearchFilter<Date> setEnd(Date newEndPoint) {
        this.givenEndDate = newEndPoint;
        IRangedQuerySearchFilter toReturn = (IRangedQuerySearchFilter)super.setEnd(this.clampDate(this.givenEndDate).getTime());
        return toReturn;
    }

    public void setSearchValue(String value) {
        if (value == null || value.equals("")) {
            return;
        }
        String[] valueList = value.split(":");
        if (valueList[1].equalsIgnoreCase(UnitOfTime.WEEK.toString())) {
            this.setRangeType(UnitOfTime.WEEK);
        } else if (valueList[1].equalsIgnoreCase(UnitOfTime.MONTH.toString())) {
            this.setRangeType(UnitOfTime.MONTH);
        }
        if (valueList[2].equalsIgnoreCase(FrequentCustomerSearchType.Frequent.toString())) {
            this.setSearchType(FrequentCustomerSearchType.Frequent);
        } else if (valueList[2].equalsIgnoreCase(FrequentCustomerSearchType.Missing.toString())) {
            this.setSearchType(FrequentCustomerSearchType.Missing);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(Long.parseLong(valueList[3].replace("l", "")));
        Date startdate = calendar.getTime();
        this.setDateRangeForWebPortal(startdate, this.getRangeType(), Integer.parseInt(valueList[0]));
    }

    private Calendar clampDate(Date dateToClamp) {
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(dateToClamp);
        if (this.rangeType == UnitOfTime.WEEK) {
            tempCal.setTime(DateTimeUtils.getEndDateForWeek(tempCal.getTime()));
        } else if (this.rangeType == UnitOfTime.MONTH) {
            tempCal.setTime(DateTimeUtils.getEndOfMonth(tempCal.getTime()).getTime());
        } else {
            throw new IllegalStateException("Frequent Customer Searcher Filter knows not of :" + (Object)((Object)this.rangeType));
        }
        DateTimeUtils.clearTimePart(tempCal);
        return tempCal;
    }

    private void checkValues() {
        Date startClamp = this.clampDate(this.givenStartDate).getTime();
        Date endClamp = this.clampDate(this.givenEndDate).getTime();
        super.setStart(startClamp);
        super.setEnd(endClamp);
        if (this.givenStartDate != null && this.givenEndDate != null) {
            int field = this.rangeType.calField;
            int modifyer = 0;
            Calendar startRange = Calendar.getInstance();
            Calendar endRange = Calendar.getInstance();
            startRange.setTime(startClamp);
            endRange.setTime(endClamp);
            int endInt = endRange.get(field);
            int startInt = startRange.get(field);
            if (endRange.get(1) - startRange.get(1) == 0) {
                this.unitOfTimeCount = endInt - startInt;
                this.oneYear = true;
            } else {
                int unitOfTimeHighestValue = this.getMaximumRange(this.rangeType);
                this.unitOfTimeCount = unitOfTimeHighestValue + endInt - startInt;
                this.oneYear = false;
            }
            if (this.unitOfTimeCount < 2 || this.unitOfTimeCount > 10) {
                throw new IllegalArgumentException("Invalid search range");
            }
            if (this.rangeType == UnitOfTime.WEEK) {
                modifyer = 3;
            }
            this.maxUnitOfTime = endRange.get(field) - modifyer;
        }
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (this.hasSearchValue()) {
            this.checkValues();
            if (this.oneYear) {
                query.selectFunc("MAX(DISTINCT(" + (Object)((Object)this.rangeType) + "(sales_item_quantity.creation_time))) as '" + MAX_VAR + "'");
            } else {
                query.selectFunc("MAX(DISTINCT(IF(" + (Object)((Object)this.rangeType) + "(sales_item_quantity.creation_time) <= " + this.maxUnitOfTime + ", " + (Object)((Object)this.rangeType) + "(sales_item_quantity.creation_time)+" + this.getMaximumRange(this.rangeType) + ", " + (Object)((Object)this.rangeType) + "(sales_item_quantity.creation_time)))) as '" + MAX_VAR + "'");
                this.maxUnitOfTime += this.getMaximumRange(this.rangeType);
            }
            query.selectFunc("  COUNT(DISTINCT(" + (Object)((Object)this.rangeType) + "(sales_item_quantity.creation_time))) as '" + COUNT_VAR + "'");
            ObjectQuery superQuery = super.addQueryRestriction(query);
            if (this.searchType == FrequentCustomerSearchType.Frequent) {
                superQuery.equals(super.getProperty(), (Object)this.unitOfTimeCount, COUNT_VAR);
            } else {
                superQuery.equals(super.getProperty(), (Object)this.maxUnitOfTime, MAX_VAR);
                superQuery.equals(super.getProperty(), (Object)(this.unitOfTimeCount - 1), COUNT_VAR);
            }
            return superQuery;
        }
        return query;
    }

    public void setRangeType(UnitOfTime value) {
        this.rangeType = value;
    }

    public void setSearchType(FrequentCustomerSearchType arg) {
        this.searchType = arg;
    }

    private int getMaximumRange(UnitOfTime type) {
        Calendar startRange = Calendar.getInstance();
        startRange.setTime(this.clampDate(this.givenStartDate).getTime());
        return startRange.getActualMaximum(type.calField);
    }

    @Override
    public boolean hasSearchValue() {
        return this.givenStartDate != null && this.givenEndDate != null;
    }

    @Override
    public void clearSearch() {
        super.clearSearch();
        this.givenStartDate = null;
        this.givenEndDate = null;
    }

    public FrequentCustomerSearchType getSearchType() {
        return this.searchType;
    }

    public UnitOfTime getRangeType() {
        return this.rangeType;
    }

    public Calendar getStartCalendar() {
        if (this.getStart() == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.getStart());
        return cal;
    }

    public Calendar getEndCalendar() {
        if (this.getEnd() == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.getEnd());
        return cal;
    }

    public void setDateRangeForWebPortal(Date startDate, UnitOfTime rangeTyp, int range) {
        Date[] dateRange = new Date[2];
        dateRange[0] = startDate;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateRange[0]);
        ((Calendar)cal).add(rangeTyp.getCalendarField(), range);
        dateRange[1] = cal.getTime();
        this.setStart(dateRange[0]);
        this.setEnd(dateRange[1]);
    }

    public static enum FrequentCustomerSearchType {
        Frequent,
        Missing;

    }

    public static enum UnitOfTime {
        WEEK(3),
        MONTH(2);

        private final int calField;

        private UnitOfTime(int theCalendarField) {
            this.calField = theCalendarField;
        }

        public int getCalendarField() {
            return this.calField;
        }
    }
}

