/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.FullTextSearch;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.search.abstracts.AbstractMultiplePropertySearchFilter;

public class FullTextJointSearchFilter
extends AbstractMultiplePropertySearchFilter
implements QuerySearchFilter {
    private String searchValue;
    private FullTextSearch.Mode mode = FullTextSearch.BOOLEAN_AND_MODE;
    private FullTextSearch.FullTextIndex index;
    private boolean orderByRelevance = true;

    public FullTextJointSearchFilter(FullTextSearch.FullTextIndex fullTextIndex) {
        super(fullTextIndex.getIndexedProperties());
        this.index = fullTextIndex;
    }

    public FullTextJointSearchFilter(FullTextSearch.FullTextIndex fullTextIndex, FullTextSearch.Mode searchMode) {
        this(fullTextIndex);
        this.mode = searchMode;
    }

    public FullTextJointSearchFilter(FullTextSearch.FullTextIndex fullTextIndex, FullTextSearch.Mode searchMode, boolean newOrderByRelevance) {
        this(fullTextIndex, searchMode);
        this.orderByRelevance = newOrderByRelevance;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        return query.wherePropsInFullTextSearch(this.getPropertyJoinPath(), this.searchValue, this.index, this.mode, this.orderByRelevance);
    }

    public void setString(String newSearchValue) {
        this.searchValue = newSearchValue;
    }

    @Override
    public void clearSearch() {
        this.setString("");
    }

    @Override
    public boolean hasSearchValue() {
        return this.searchValue != null && !this.searchValue.isEmpty();
    }

    public String toString() {
        return "FullTextFilter[" + this.getProperty() + "=" + this.searchValue + "]";
    }

    public String getSearchValue() {
        return this.searchValue;
    }

    public FullTextSearch.FullTextIndex getIndex() {
        return this.index;
    }
}

