/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Calendar;
import java.util.Date;

public class FuzzyDateRangeSearchFilter
extends RangeQuerySearchFilter<Date> {
    private long startFuzzy;
    private long endFuzzy;
    private final SQLDateType dateType;

    public FuzzyDateRangeSearchFilter(PropertiedObject.Property prop, SQLDateType sqlDateType, long fuzzinessBeforeStart, long fuzzinessAfterEnd) {
        super(prop);
        this.dateType = sqlDateType;
        this.startFuzzy = fuzzinessBeforeStart;
        this.endFuzzy = fuzzinessAfterEnd;
    }

    @Override
    public boolean hasSearchValue() {
        return this.getStart() != null && this.getEnd() != null;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(((Date)this.getStart()).getTime() - this.startFuzzy);
        Calendar endCal = Calendar.getInstance();
        endCal.setTimeInMillis(((Date)this.getEnd()).getTime() + this.endFuzzy);
        if (startCal.compareTo(endCal) > 0) {
            Calendar temp = startCal;
            startCal = endCal;
            endCal = temp;
        }
        return query.wherePropertyBetween(this.getProperty(), startCal.getTime(), endCal.getTime(), this.dateType);
    }
}

