/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.abstracts.AbstractSinglePropertySearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MultiOptionSearchFilter<T>
extends AbstractSinglePropertySearchFilter
implements SingleValueQuerySearchFilter {
    Set<T> searchOptions = new LinkedHashSet<T>();
    private String propertyString;

    public MultiOptionSearchFilter(PropertiedObject.Property<T> searchProperty) {
        super(searchProperty);
    }

    public static <T> SingleValueQuerySearchFilter<T> create(List<T> searchOptions, PropertiedObject.Property ... joinPath) {
        if (joinPath == null || joinPath.length <= 0) {
            throw new IllegalArgumentException("Must specify at least one property");
        }
        MultiOptionSearchFilter<T> filter = new MultiOptionSearchFilter<T>(joinPath[joinPath.length - 1]);
        filter.setSearchOptions(searchOptions);
        if (joinPath.length > 1) {
            return new ObjectJoinSearchFilter<T>(joinPath, filter);
        }
        return filter;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        Set options = this.getSearchOptions();
        if (!this.hasSearchValue() || options.size() <= 0) {
            return query;
        }
        if (this.propertyString != null) {
            return query.whereIn(this.propertyString, new ArrayList(options));
        }
        if (options.size() > 1) {
            return query.wherePropertyIn(this.getProperty(), new ArrayList(options));
        }
        if (options.size() == 1) {
            return query.equals(this.getProperty(), options.iterator().next());
        }
        throw new IllegalStateException("list size changed during if statement");
    }

    public Set getSearchOptions() {
        return this.searchOptions;
    }

    public void setPropertyString(String value) {
        this.propertyString = value;
    }

    @Override
    public void setSearchValue(Object obj) {
        if (obj instanceof Collection) {
            this.setSearchOptions((Collection)obj);
        } else if (obj == null) {
            this.setSearchOptions(Collections.EMPTY_LIST);
        } else if (obj instanceof Object[]) {
            this.setSearchOptions(Arrays.asList((Object[])obj));
        } else {
            this.setSearchOptions(Arrays.asList(obj));
        }
    }

    public void setSearchOptions(Collection newSelectedOptions) {
        ArrayList<T> oldValue = new ArrayList<T>(this.searchOptions);
        this.searchOptions.clear();
        this.searchOptions.addAll(newSelectedOptions);
        this.firePropertyChange(oldValue, this.searchOptions);
    }

    public List<T> getSelectedOptions() {
        return Collections.unmodifiableList(new ArrayList(this.getSearchOptions()));
    }

    @Override
    public Object getSearchValue() {
        return this.getSelectedOptions();
    }

    @Override
    public void clearSearch() {
        this.searchOptions.clear();
    }

    public void addSearchOptions(Collection newSelectedOptions) {
        this.searchOptions.addAll(newSelectedOptions);
    }

    @Override
    public boolean hasSearchValue() {
        return this.searchOptions != null && this.searchOptions.size() > 0;
    }

    public String toString() {
        return "MultiOptionFilter[" + this.getProperty() + "=" + this.searchOptions + "]";
    }

    public int getSelectedCount() {
        return this.searchOptions != null ? this.getSelectedOptions().size() : 0;
    }
}

