/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.sales.SalesItemQuantity;

public class NewCustomerSearchFilter
extends RangeQuerySearchFilter<Date> {
    private static final String NEW_CUSTOMER_FILTER_COLUMN = "creation_time";

    public NewCustomerSearchFilter(PropertiedObject.Property prop) {
        super(prop);
        this.setHavingAlias(NEW_CUSTOMER_FILTER_COLUMN);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        ObjectQuery superQuery = super.addQueryRestriction(query);
        if (this.hasSearchValue()) {
            superQuery.min(SalesItemQuantity.Properties.CREATION_TIME, NEW_CUSTOMER_FILTER_COLUMN);
        }
        return superQuery;
    }

    public Date[] getSearchValue() {
        return new Date[]{(Date)this.getStart(), (Date)this.getEnd()};
    }
}

