/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.abstracts.AbstractSinglePropertySearchFilter;

public class PrefixTextSearchFilter
extends AbstractSinglePropertySearchFilter
implements SingleValueQuerySearchFilter {
    private String searchPrefix;

    public PrefixTextSearchFilter(PropertiedObject.Property prop) {
        super(prop);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        return query.startsWith(this.getProperty(), this.getSearchString());
    }

    @Override
    public void setSearchValue(Object obj) {
        this.setSearchValue(obj != null ? obj.toString() : null);
    }

    @Override
    public void setSearchValue(String prefix) {
        this.searchPrefix = prefix;
    }

    @Override
    public Object getSearchValue() {
        return this.searchPrefix;
    }

    protected String getSearchString() {
        return this.searchPrefix;
    }

    @Override
    public void clearSearch() {
        this.searchPrefix = "";
    }

    @Override
    public boolean hasSearchValue() {
        return this.searchPrefix != null && !this.searchPrefix.equals("");
    }

    public String toString() {
        return "PrefixFilter[" + this.getProperty() + " starts with " + this.searchPrefix + "]";
    }
}

