/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.abstracts.SimpleMultiplePropertySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;

public class RangeJoinSearchFilter<T extends Comparable<T>>
extends SimpleMultiplePropertySearchFilter
implements IRangedQuerySearchFilter<T> {
    IRangedQuerySearchFilter<T> searchProperty;

    public RangeJoinSearchFilter(PropertiedObject.Property[] props, IRangedQuerySearchFilter<T> rangedProp) {
        super(props);
        this.searchProperty = rangedProp;
    }

    public RangeJoinSearchFilter(IRangedQuerySearchFilter<T> rangedProp, PropertiedObject.Property ... props) {
        this(props, rangedProp);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (this.hasSearchValue()) {
            super.addQueryRestriction(query);
            this.searchProperty.addQueryRestriction(query);
        }
        return query;
    }

    @Override
    public boolean hasSearchValue() {
        return this.getStart() != null && this.getEnd() != null;
    }

    @Override
    public void clearSearch() {
        this.searchProperty.clearSearch();
    }

    public IRangedQuerySearchFilter setEnd(T end) {
        this.searchProperty.setEnd(end);
        return this;
    }

    public IRangedQuerySearchFilter setStart(T start) {
        this.searchProperty.setStart(start);
        return this;
    }

    @Override
    public T getStart() {
        return this.searchProperty.getStart();
    }

    @Override
    public T getEnd() {
        return this.searchProperty.getEnd();
    }

    @Override
    public PropertiedObject.Property getProperty() {
        return this.searchProperty.getProperty();
    }

    public String toString() {
        return "RangeJoinFilter[" + this.getProperty() + " IN " + this.searchProperty.getStart() + ", " + this.searchProperty.getEnd() + "]";
    }
}

