/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.abstracts.RangeSearchFilter;
import java.util.Date;

public class RangeQuerySearchFilter<T extends Comparable<T>>
extends RangeSearchFilter<T>
implements IRangedQuerySearchFilter<T> {
    public RangeQuerySearchFilter(PropertiedObject.Property prop) {
        super(prop);
    }

    public RangeQuerySearchFilter(PropertiedObject.Property prop, SQLDateType type) {
        super(prop);
        this.datetype = type;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        Comparable start = this.startRange;
        Comparable end = this.endRange;
        if (this.startRange.compareTo(this.endRange) > 0) {
            start = this.endRange;
            end = this.startRange;
        }
        if (this.havingAlias != null) {
            if (start instanceof Date) {
                return query.havingPropertyBetween(this.getProperty(), (Date)start, (Date)end, this.datetype, this.havingAlias);
            }
            return query.havingPropertyBetween(this.getProperty(), start, end, this.havingAlias);
        }
        if (start instanceof Date) {
            return query.wherePropertyBetween(this.getProperty(), (Date)start, (Date)end, this.datetype);
        }
        return query.wherePropertyBetween(this.getProperty(), start, end);
    }

    @Override
    public void setHavingAlias(String value) {
        this.havingAlias = value;
    }
}

