/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.SQLPeriodFunction;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class SQLFunctionSearchFilter
extends ObjectSearchFilter<Date> {
    private SQLPeriodFunction function;
    private SQLDateType dateType = null;

    public SQLFunctionSearchFilter(SQLPeriodFunction function, PropertiedObject.Property<Date> prop) {
        super(prop);
        this.function = function;
    }

    public void setDateType(SQLDateType value) {
        this.dateType = value;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        Object searchValue = this.getSearchValue();
        if (searchValue instanceof PersistentObject && ((PersistentObjectI)searchValue).isPersistent()) {
            searchValue = ((PersistentObjectI)searchValue).getID();
        } else if (searchValue instanceof Date) {
            long millis = ((Date)searchValue).getTime();
            searchValue = this.dateType != null || SQLDateType.DATE.equals((Object)this.dateType) ? new java.sql.Date(millis) : (SQLDateType.TIME.equals((Object)this.dateType) ? new Time(millis) : new Timestamp(millis));
        }
        return query.whereFunctionEquals(this.function, this.getProperty(), searchValue);
    }
}

