/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.abstracts.AbstractSinglePropertySearchFilter;

public class TextSearchFilter
extends AbstractSinglePropertySearchFilter
implements SingleValueQuerySearchFilter {
    private TextSearchStrategy strategy = TextSearchStrategy.Like;
    private String searchValue;

    public TextSearchFilter(PropertiedObject.Property prop) {
        this(prop, TextSearchStrategy.Like);
    }

    public TextSearchFilter(PropertiedObject.Property prop, TextSearchStrategy strategy) {
        super(prop);
        this.strategy = strategy;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        if (TextSearchStrategy.StartsWith.equals((Object)this.strategy)) {
            return query.startsWith(this.getProperty(), this.getSearchString());
        }
        return query.wherePropertyLike(this.getProperty(), this.getSearchString());
    }

    @Override
    public void setSearchValue(Object obj) {
        this.setSearchValue(obj != null ? obj.toString() : null);
    }

    @Override
    public void setSearchValue(String prefix) {
        this.searchValue = prefix;
    }

    @Override
    public Object getSearchValue() {
        return this.searchValue;
    }

    protected String getSearchString() {
        return this.searchValue;
    }

    @Override
    public void clearSearch() {
        this.searchValue = "";
    }

    @Override
    public boolean hasSearchValue() {
        return this.searchValue != null && !this.searchValue.equals("");
    }

    public String toString() {
        return "TextFilter[" + this.getProperty() + " contains " + this.searchValue + "]";
    }

    public static enum TextSearchStrategy {
        Like,
        StartsWith;

    }
}

