/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.oquery.search.filter.implementation;

import au.com.ordermate.guicore.TreeNodeSupport;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.abstracts.SimpleMultiplePropertySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.List;
import javax.swing.tree.TreeNode;

public class TreeNodeChildSearchFilter<T extends TreeNode>
extends SimpleMultiplePropertySearchFilter
implements ISingleValueSearchFilter<T> {
    private T rootNode;

    public TreeNodeChildSearchFilter(PropertiedObject.Property<T> property) {
        this(new PropertiedObject.Property[]{property});
    }

    public TreeNodeChildSearchFilter(PropertiedObject.Property[] propertyJoinPath) {
        super(propertyJoinPath);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        ObjectQuery restrictedQuery = super.addQueryRestriction(query);
        if (this.rootNode != null) {
            if (this.rootNode instanceof PersistentObject) {
                this.rootNode = (TreeNode)PersistenceManager.reacquire((PersistentObject)this.rootNode);
            }
            if (this.rootNode.isLeaf()) {
                restrictedQuery.wherePropertyIn(this.getProperty(), new TreeNode[]{this.rootNode});
            } else {
                List<? extends TreeNode> children = TreeNodeSupport.getAllChildren(this.rootNode);
                children.add(0, (TreeNode)this.rootNode);
                restrictedQuery.wherePropertyIn(this.getProperty(), children);
            }
        }
        return restrictedQuery;
    }

    @Override
    public void clearSearch() {
        this.setSearchValue((T)null);
    }

    @Override
    public boolean hasSearchValue() {
        return this.getSearchValue() != null;
    }

    @Override
    public T getSearchValue() {
        return this.rootNode;
    }

    @Override
    public void setSearchValue(T value) {
        this.rootNode = value;
    }
}

