/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractPersistentList<E extends PersistentObjectI>
extends AbstractList<E>
implements PersistentList<E>,
Serializable,
Cloneable {
    private volatile List<E> mainList;
    private PersistentObject owner;
    private Class<E> listType;
    private PropertiedObject.Property linkBack;
    private volatile boolean downloaded = false;
    private final boolean collapseOnSerialize;
    protected PropertiedObject.Property ownerProperty;

    public AbstractPersistentList() {
        this.collapseOnSerialize = false;
    }

    public AbstractPersistentList(Class<E> newListType) {
        this.listType = newListType;
        this.collapseOnSerialize = false;
    }

    public AbstractPersistentList(Class<E> newListType, boolean collapse) {
        this.listType = newListType;
        this.collapseOnSerialize = collapse;
    }

    public AbstractPersistentList linkBack(PropertiedObject.Property newLinkBack) {
        this.linkBack = newLinkBack;
        return this;
    }

    @Override
    public final void setOwner(PersistentObject newOwner) {
        this.owner = newOwner;
    }

    public final PersistentObject getOwner() {
        return this.owner;
    }

    @Override
    public final synchronized boolean isExpanded() {
        if (this.owner == null) {
            throw new IllegalStateException("hasDownloadedData cannot be called, until owner is set");
        }
        return this.downloaded && this.owner.isPersistent();
    }

    public AbstractPersistentList setReferenceProperty(PropertiedObject.Property property) {
        this.ownerProperty = property;
        return this;
    }

    private Reference getOwnerReference() {
        try {
            return (Reference)PropertyUtils.getProperty((Object)this.owner, (String)this.ownerProperty.getName());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Long getID() {
        Long id = this.ownerProperty == null ? this.getOwner().getID() : this.getOwnerReference().getObjectID();
        return id;
    }

    protected final synchronized void downloadData() {
        if (!this.downloaded) {
            if (this.owner == null || this.owner.isPersistent() || this.ownerProperty != null) {
                Collection<PersistentObjectI> data = this.safeResolve();
                if (this.owner != null && this.hasLinkBack() && this.ownerProperty == null) {
                    Iterator<E> iterator = data.iterator();
                    while (iterator.hasNext()) {
                        this.setupLinkBack(iterator.next());
                    }
                }
                for (PersistentObjectI obj : this.getMainList()) {
                    if (obj.isPersistent() && data.contains(obj)) continue;
                    data.add(obj);
                }
                this.getMainList().clear();
                this.getMainList().addAll(data);
            }
            this.downloaded = true;
        }
    }

    private Collection<E> safeResolve() {
        Collection<E> data;
        try {
            data = this.resolve();
            if (data == null) {
                throw new IllegalStateException("data should not resolve to null");
            }
        }
        catch (Exception e) {
            String s = "Error downloading persistent list data";
            throw new RuntimeException(s, e);
        }
        return data;
    }

    protected final void setupLinkBack(Object ownedByThisList) {
        if (this.ownerProperty == null) {
            PersistentList.LinkBackHelper.setupLinkBack(this.linkBack, ownedByThisList, this.owner);
        }
    }

    public final PropertiedObject.Property getLinkBack() {
        return this.linkBack;
    }

    public final boolean hasLinkBack() {
        return this.linkBack != null;
    }

    public final void setType(Class<E> type) {
        this.listType = type;
    }

    public final Class<E> getType() {
        return this.listType;
    }

    protected abstract Collection<E> resolve() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.collapseOnSerialize) {
            AbstractPersistentList abstractPersistentList = this;
            synchronized (abstractPersistentList) {
                List<E> tempList = null;
                if (this.collapseOnSerialize) {
                    tempList = this.getMainList();
                    this.collapse();
                }
                stream.defaultWriteObject();
                if (tempList != null) {
                    this.getMainList().addAll(tempList);
                }
            }
        } else {
            stream.defaultWriteObject();
        }
    }

    @Override
    public void collapse() {
        if (!this.owner.isPersistent()) {
            throw new IllegalStateException("Cannot collapse unless owner is persistent");
        }
        if (Saveable.class.isAssignableFrom(this.listType) || SaveableChild.class.isAssignableFrom(this.listType)) {
            throw new IllegalStateException("Cannot collapse as list contents are saveable and may be changed");
        }
        this.collapseUnsafe();
    }

    @Override
    public synchronized void collapseUnsafe() {
        if (this.downloaded) {
            this.setMainList(null);
            this.downloaded = false;
        }
    }

    @Override
    public PersistentList<E> clone() {
        try {
            AbstractPersistentList clone = (AbstractPersistentList)super.clone();
            clone.setMainList(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            OrderMateLog.LOG.error("Java is stupid", (Throwable)e);
            return null;
        }
    }

    @Override
    public final synchronized List<E> getUnmodifiable() {
        this.downloadData();
        return Collections.unmodifiableList(this);
    }

    @Override
    public synchronized E get(int index) {
        this.downloadData();
        return (E)((PersistentObjectI)this.getMainList().get(index));
    }

    @Override
    public synchronized int size() {
        this.downloadData();
        return this.getMainList().size();
    }

    @Override
    public synchronized Iterator<E> iterator() {
        this.downloadData();
        return this.getMainList().iterator();
    }

    @Override
    public synchronized ListIterator<E> listIterator() {
        this.downloadData();
        return this.getMainList().listIterator();
    }

    @Override
    public synchronized ListIterator<E> listIterator(int index) {
        this.downloadData();
        return this.getMainList().listIterator(index);
    }

    @Override
    public synchronized boolean contains(E o) {
        this.downloadData();
        return this.getMainList().contains(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        this.downloadData();
        return this.getMainList().containsAll(c);
    }

    @Override
    public synchronized int indexOf(E o) {
        this.downloadData();
        return this.getMainList().indexOf(o);
    }

    @Override
    public synchronized boolean isEmpty() {
        this.downloadData();
        return this.getMainList().isEmpty();
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        this.downloadData();
        return this.getMainList().lastIndexOf(o);
    }

    @Override
    public synchronized Object[] toArray() {
        this.downloadData();
        return this.getMainList().toArray();
    }

    @Override
    public synchronized E[] toArray(E[] a) {
        this.downloadData();
        return (PersistentObjectI[])this.getMainList().toArray(a);
    }

    @Override
    public synchronized List<E> subList(int fromIndex, int toIndex) {
        this.downloadData();
        return this.getMainList().subList(fromIndex, toIndex);
    }

    @Override
    public void initSQL() throws Exception {
    }

    public String toDebugString() {
        Iterator<E> it = this.iterator();
        String returnString = (this.listType != null ? "List of " + this.listType.getSimpleName() : "") + " Owned by: " + this.owner + " with property : " + this.ownerProperty;
        returnString = it.hasNext() ? returnString + "\nContains : " : returnString + " is empty";
        while (it.hasNext()) {
            returnString = returnString + it.next();
            if (!it.hasNext()) continue;
            returnString = returnString + ",";
        }
        return returnString;
    }

    private synchronized void setMainList(List<E> list) {
        this.mainList = list;
    }

    protected synchronized List<E> getMainList() {
        if (this.mainList == null) {
            this.mainList = new ArrayList();
        }
        return this.mainList;
    }

    @Override
    public void set(List list) {
        this.clear();
        this.setMainList(new ArrayList(list));
    }
}

