/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.bytecode.opencsv.CSVWriter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.csvwritestrategy.DefaultPersistentObjCSVWriteStrategy;
import au.com.ordermate.persistence.csvwritestrategy.PropertiedObjCSVWriteStrategy;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.CSVColumn;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.PropertyAccessorCSVColumn;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;

public class CSVPropertiedObjExporter<T extends PropertiedObject> {
    private CSVHeaderStyle headerStyle = CSVHeaderStyle.FIRST;
    private Map<Class<? extends PropertiedObject>, List<CSVColumn>> colMap;
    private boolean addWhitespace = false;
    private char seperator = (char)44;
    private char quote = (char)34;
    private String lineEnd = "\n";

    public CSVPropertiedObjExporter(List<CSVColumn> cols) {
        this(new DefaultPersistentObjCSVWriteStrategy(cols));
    }

    public CSVPropertiedObjExporter(PropertiedObjCSVWriteStrategy<T> writeStrategy) {
        this.colMap = writeStrategy.getClassColumnMap();
        writeStrategy.configureExporter(this);
    }

    public CSVPropertiedObjExporter(Class<T> classToExport, Set propertiesToExclude) {
        ArrayList<PropertiedObject.Property> propsToExport = new ArrayList<PropertiedObject.Property>();
        for (Object prop : PropertiedObject.PropsHelper.getProperties(classToExport)) {
            if (propertiesToExclude.contains(prop)) continue;
            propsToExport.add((PropertiedObject.Property)prop);
        }
        if (propsToExport.size() == 0) {
            throw new IllegalStateException("No properties left to export for class : " + classToExport);
        }
        ArrayList<CSVColumn> colsToUse = new ArrayList<CSVColumn>();
        for (PropertiedObject.Property prop : propsToExport) {
            colsToUse.add(new PropertyAccessorCSVColumn(prop));
        }
        DefaultPersistentObjCSVWriteStrategy writeStrategy = new DefaultPersistentObjCSVWriteStrategy(colsToUse);
        this.colMap = writeStrategy.getClassColumnMap();
        writeStrategy.configureExporter(this);
    }

    public void setCSVHeaderStyle(CSVHeaderStyle newHeaderStyle) {
        this.headerStyle = newHeaderStyle;
    }

    public void setSeperator(char seperator) {
        this.seperator = seperator;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public void setLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
    }

    public void setAddwhiteSpace(boolean newWhitespace) {
        this.addWhitespace = newWhitespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Writer theWriter, List<T> toExport) throws IOException {
        CSVWriter writer = null;
        try {
            writer = new CSVWriter(theWriter, this.seperator, this.quote, this.lineEnd);
            boolean noHeaderWritten = true;
            ArrayList<String> line = new ArrayList<String>();
            for (PropertiedObject persistObj : toExport) {
                if (noHeaderWritten && CSVHeaderStyle.FIRST.equals((Object)this.headerStyle)) {
                    this.writeHeader(writer, this.getClassColumns(persistObj.getClass()));
                    noHeaderWritten = false;
                } else if (CSVHeaderStyle.ALWAYS.equals((Object)this.headerStyle)) {
                    this.writeHeader(writer, this.getClassColumns(persistObj.getClass()));
                    noHeaderWritten = false;
                }
                for (CSVColumn col : this.getClassColumns(persistObj.getClass())) {
                    line.add(col.getColumnDataForObject(persistObj));
                }
                this.writeNext(writer, line);
                line.clear();
                if (!this.addWhitespace) continue;
                this.writeNext(writer, line);
                line.clear();
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("An error occurred closing the file writer.", (Throwable)ex);
            }
        }
    }

    public void export(File file, List<T> toExport) throws IOException {
        this.export(new FileWriter(file), toExport);
    }

    private void writeHeader(CSVWriter writer, List<CSVColumn> columns) {
        ArrayList<String> header = new ArrayList<String>();
        for (CSVColumn col : columns) {
            header.add(col.getColumnHeader());
        }
        this.writeNext(writer, header);
    }

    private void writeNext(CSVWriter writer, List<String> toWrite) {
        writer.writeNext(toWrite.toArray(new String[toWrite.size()]));
    }

    private List<CSVColumn> getClassColumns(Class<? extends PropertiedObject> clazzToGet) {
        List<CSVColumn> toReturn = this.colMap.get(clazzToGet);
        return toReturn != null ? toReturn : this.colMap.get(null);
    }

    public static enum CSVHeaderStyle {
        FIRST,
        ALWAYS;

    }
}

