/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.OrderBy;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.list.AbstractPersistentWriteableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class FKList<E extends PersistentObject>
extends AbstractPersistentWriteableList<E> {
    private List<OrderBy> orderByConditions;
    private List<PropertiedObject.Property> linkProperties;
    private boolean deleteOnRemove = false;
    private boolean checkActive;
    private String whereClause = null;
    private boolean checkDeleted = false;
    private transient String sql;

    public FKList(Class<E> newListType, PropertiedObject.Property linkBack) {
        super(newListType, linkBack);
    }

    public FKList(Class<E> newListType, PropertiedObject.Property linkBack, boolean collapse) {
        super(newListType, linkBack, collapse);
    }

    public FKList<E> deleteOnRemove(boolean shouldDelete) {
        this.deleteOnRemove = shouldDelete;
        return this;
    }

    public FKList<E> checkActive(boolean newCheckActive) {
        this.checkActive = newCheckActive;
        return this;
    }

    public FKList<E> whereClause(String where) {
        this.whereClause = where;
        return this;
    }

    public FKList<E> orderBy(PropertiedObject.Property toOrderBy) {
        OrderBy orderBy = new OrderBy(toOrderBy);
        this.getOrderByList().add(orderBy);
        return this;
    }

    public FKList<E> orderBy(OrderBy orderBy) {
        this.getOrderByList().add(orderBy);
        return this;
    }

    private List<OrderBy> getOrderByList() {
        if (this.orderByConditions == null) {
            this.orderByConditions = new ArrayList<OrderBy>();
        }
        return this.orderByConditions;
    }

    private List<PropertiedObject.Property> getLinkProperties() {
        if (this.linkProperties == null) {
            this.linkProperties = new ArrayList<PropertiedObject.Property>();
        }
        return this.linkProperties;
    }

    public FKList<E> orderBy(OrderBy orderBy, PropertiedObject.Property linkUsing) {
        if (orderBy.getProperty().getClass() != linkUsing.getClass()) {
            throw new IllegalArgumentException("Link class not equal to order by class, cannot construct link for this order by");
        }
        this.getOrderByList().add(orderBy);
        this.getLinkProperties().add(linkUsing);
        return this;
    }

    @Override
    public void initSQL() throws Exception {
        ObjectQuery oQuery = this.getObjectQuery();
        this.sql = oQuery.toString();
    }

    protected ObjectQuery getObjectQuery() {
        ObjectQuery oQuery = Query.select(this.getType()).equalsParam(this.getLinkBack());
        if (this.checkActive) {
            oQuery.active(this.getType());
        } else if (this.isCheckDeleted()) {
            oQuery.not().deleted(this.getType());
        }
        if (this.whereClause != null) {
            oQuery.whereFunction(this.whereClause);
        }
        if (this.orderByConditions != null) {
            for (OrderBy orderBy : this.orderByConditions) {
                oQuery.orderBy(orderBy);
            }
        }
        if (this.linkProperties != null) {
            for (PropertiedObject.Property property : this.linkProperties) {
                oQuery.linkUsing(property);
            }
        }
        return oQuery;
    }

    @Override
    protected Collection<E> resolve() throws Exception {
        if (this.sql == null) {
            this.initSQL();
        }
        if (this.getID() != null) {
            SessionI session = null;
            if (this.getOwner() != null) {
                session = this.getOwner().getSession();
            }
            List databaseObjs = PersistenceManager.getObjectList(this.getType(), this.sql, new Object[]{this.getID()}, session);
            this.registerToSession(databaseObjs);
            if (this.getLocalObjects().size() > 0) {
                LinkedHashSet<PersistentObject> set = new LinkedHashSet<PersistentObject>(databaseObjs);
                for (PersistentObject obj : this.getLocalObjects()) {
                    set.add(obj);
                }
                return set;
            }
            return databaseObjs;
        }
        return new ArrayList();
    }

    protected void registerToSession(List<E> objects) {
        SessionI session = this.getOwner().getSession();
        if (session != null) {
            session.registerObjects(objects);
        }
    }

    protected void registerToSession() {
        SessionI session = this.getOwner().getSession();
        if (session != null) {
            session.registerObjects(this.getMainList());
        }
    }

    public void preloadReferences(Class[] ignoreList) {
        this.downloadData();
        Class type = this.getType();
        Field[] members = type.getDeclaredFields();
        ArrayList<Field> references = new ArrayList<Field>();
        for (int i = 0; i < members.length; ++i) {
            if (!FKReference.class.isAssignableFrom(members[i].getType())) continue;
            references.add(members[i]);
        }
        Iterator it = references.iterator();
        while (it.hasNext()) {
            this.preloadReference((Field)it.next(), ignoreList);
        }
    }

    private void preloadReference(Field reference, Class[] ignoreList) {
        PersistenceMetaData metaData = PersistenceManager.getPersistenceMetaData();
        String preloadSql = "";
        boolean first = true;
        Iterator it = this.iterator();
        HashSet<Long> params = new HashSet<Long>();
        Class referenceType = null;
        try {
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!(obj.getRawFieldValue(reference.getName()) instanceof FKReference)) continue;
                if (first) {
                    referenceType = ((FKReference)obj.getRawFieldValue(reference.getName())).getType();
                    if (ignoreList != null && Arrays.asList(ignoreList).contains(referenceType)) {
                        return;
                    }
                    String table = metaData.getClassTable(referenceType);
                    preloadSql = "SELECT " + table + ".* FROM " + table + " WHERE " + table + "." + metaData.getPropertyColumn(new PropertiedObject.Property(this.getType(), "ID")) + " IN (";
                }
                if (!params.add(((FKReference)obj.getRawFieldValue(reference.getName())).getObjectID())) continue;
                if (!first) {
                    preloadSql = preloadSql + ",";
                } else {
                    first = false;
                }
                preloadSql = preloadSql + "?";
            }
            preloadSql = preloadSql + ")";
            if (first) {
                return;
            }
            HashMap map = PersistenceManager.getHashMapFromObjectList(PersistenceManager.getObjectList(referenceType, preloadSql, params.toArray(new Integer[params.size()])));
            for (PersistentObject obj : this) {
                FKReference instance = (FKReference)obj.getRawFieldValue(reference.getName());
                instance.set((PersistentObjectI)map.get(instance.getObjectID()));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void saveObject(E save) throws Exception {
        if (save instanceof SaveableChild) {
            ((SaveableChild)save).saveChild();
        } else if (save instanceof Saveable) {
            ((Saveable)save).save();
        } else {
            throw new IllegalStateException("FKList must contain SaveableChild or Saveableobjects, but found a " + save.getClass());
        }
    }

    @Override
    protected void prepareObjectForSave(E save, SaveContext context) throws Exception {
        if (save instanceof SaveableChild) {
            ((SaveableChild)save).prepareForSave(context);
        } else if (save instanceof Saveable) {
            ((Saveable)save).prepareForSave(context);
        } else {
            throw new IllegalStateException("FKList must contain SaveableChild or Saveableobjects, but found a " + save.getClass());
        }
    }

    @Override
    protected void deleteObject(E toDelete) throws Exception {
        if (toDelete instanceof SaveableChild) {
            SaveableChild delete = (SaveableChild)toDelete;
            if (!toDelete.isPersistent()) {
                return;
            }
            if (this.deleteOnRemove) {
                delete.deleteChild();
            } else {
                delete.saveChild();
            }
        } else if (toDelete instanceof Saveable) {
            Saveable delete = (Saveable)toDelete;
            if (!toDelete.isPersistent()) {
                return;
            }
            if (this.deleteOnRemove) {
                delete.delete();
            } else {
                delete.save();
            }
        } else {
            throw new IllegalStateException("FKList must contain SaveableChild objects, but found a " + toDelete.getClass());
        }
    }

    public FKList<E> checkDeleted(boolean newCheckDeleted) {
        this.checkDeleted = newCheckDeleted;
        return this;
    }

    public boolean isCheckDeleted() {
        return this.checkDeleted;
    }
}

